package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.LotteryActivityPrize.F_LOTTERY_ACTIVITY_AWARD_ID;

import java.util.Collection;
import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.LotteryActivityPrize;
import com.thebeastshop.scm.vo.lottery.LotteryActivityPrizeVO;

@DaoConfig(table = "lottery_activity_prize")
public class LotteryActivityPrizeDao extends BaseDao<LotteryActivityPrize>{
	
	@Autowired
	public LotteryActivityPrizeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public LotteryActivityPrize byAwardId(Integer awardId){
		return super.selectOne(new WhereBuilder(F_LOTTERY_ACTIVITY_AWARD_ID, awardId));
	}
	
	public List<LotteryActivityPrizeVO> byLotteryActivityId(Integer lotteryActivityId){
		return super.selectOne("byLotteryActivityId", lotteryActivityId);
	}
	
	public void deleteByAwardId(Integer awardId){
		super.delete(new WhereBuilder(F_LOTTERY_ACTIVITY_AWARD_ID, awardId));
	}
	
	public void deleteByAwardId(Collection<Integer> awardIds){
		super.delete(new WhereBuilder().in(F_LOTTERY_ACTIVITY_AWARD_ID, awardIds));
	}
}