package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.LotteryActivityAward.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.vo.lottery.LotteryActivityAwardEditVO;

@DaoConfig(table = "lottery_activity_award")
public class LotteryActivityAwardDao extends BaseDao<LotteryActivityAward>{
	@Resource private LotteryActivityPrizeDao lotteryActivityPrizeDao;	
	
	@Autowired
	public LotteryActivityAwardDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 得到有还有抽奖数库存的
	 * @param lotteryActivityId
	 * @return
	 */
	public List<LotteryActivityAward> byLotteryActivityIdAndStock(Integer lotteryActivityId){
		return this.selectList(new WhereBuilder(F_LOTTERY_ACTIVITY_ID, lotteryActivityId).gt(F_STOCK, 0).orderAsc(F_QUANTITY));
	}
	
	
	public void batchSave(List<LotteryActivityAward> lotteryActivityAwardList){
		if (CollectionUtils.isEmpty(lotteryActivityAwardList)) {
			return;
		}
		Integer lotteryActivityId = lotteryActivityAwardList.get(0).getLotteryActivityId();
		List<Integer> ids = super.selectFieldList(F_ID, new WhereBuilder(F_LOTTERY_ACTIVITY_ID, lotteryActivityId));
		List<Integer> listIds = new ArrayList<>();
		for (LotteryActivityAward lotteryActivityAward : lotteryActivityAwardList) {
			listIds.add(lotteryActivityAward.getId());
			super.insertOrUpdate(lotteryActivityAward);
		}
		Collection<Integer> deleteIds = CollectionUtils.subtract(ids, listIds);
		if (CollectionUtils.isNotEmpty(deleteIds)) {
			int num = super.delete(new WhereBuilder().in(F_ID, deleteIds));
			lotteryActivityPrizeDao.deleteByAwardId(deleteIds);
			log.debug("删除lottery_activity_award表{}条记录", num);
		}
	}
	
	public List<LotteryActivityAwardEditVO> getLotteryActivityAwardEditVOByLotteryActivityId(Integer lotteryActivityId){
		return super.selectList("getLotteryActivityAwardEditVOByLotteryActivityId", lotteryActivityId);
	}
	
	/**
	 * 减少奖项的库存(使用乐观锁机制更新)
	 * @param id
	 * @return 更新是否成功
	 */
	public boolean updateStock(Integer id){
		List<Integer> versionList = super.selectFieldList(F_VERSION, new WhereBuilder(F_ID, id));
		Integer version = ObjUtils.get(versionList, 0);
		UpdateBuilder ub = new UpdateBuilder().updateIncr(F_STOCK, -1)
			.whereEq(F_ID, id).whereQt(F_STOCK, 0).whereEq(F_VERSION, version);
		int num = super.update(ub);
		return num == 1;
	}
	
}