package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ProdDynmCont.*;

import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.es.PsDynmContentVO;
import com.thebeastshop.scm.po.ProdDynmCont;
import com.thebeastshop.scm.po.ProdDynmCont.ContentType;

@DaoConfig(table = "t_op_prod_dynm_cont")
public class ProdDynmContDao extends BaseDao<ProdDynmCont>{
	
	@Autowired
	public ProdDynmContDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<PsDynmContentVO> getMapByProdId(Integer productId){
		return super.selectList("getPsDynmContentVOByProdId", productId);
	}

	public void batchSave(List<ProdDynmCont> list) {
		if (CollectionUtils.isEmpty(list)) {
			return;
		}
		Integer prodId = ObjUtils.get(list, 0).getProductId();
		int num = this.delete(new WhereBuilder(F_PRODUCT_ID, prodId));
		log.debug("删除productId:{}条记录", num);
		for (ProdDynmCont prodDynmCont : list) {
			super.insertOrUpdate(prodDynmCont, new WhereBuilder(F_PRODUCT_ID, prodId).eq(F_CONTENT_TYPE, prodDynmCont.getContentType()));
		}
	}
	
	public void saveByProdCodeAndType(Integer productId, String content, Integer contentTypeIndex) {
		if (StringUtils.isBlank(content)) {
			return;
		}
		ContentType contentType = ContentType.values()[contentTypeIndex - 1];
		ProdDynmCont prodDynmCont = new ProdDynmCont();
		prodDynmCont.setProductId(productId);
		prodDynmCont.setContent(content);
		prodDynmCont.setSort(contentTypeIndex);
		prodDynmCont.setContentType(contentType.getType());
		prodDynmCont.setTitleCn(contentType.getNameCn());
		prodDynmCont.setTitleEn(contentType.getNameEn());
		super.insertOrUpdate(prodDynmCont, new WhereBuilder(F_PRODUCT_ID, productId).eq(F_CONTENT_TYPE, contentType.getType()));
	}
	
}