package com.thebeastshop.scm.dao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Brand;

@DaoConfig(table = "t_pcs_brand")
public class BrandDao extends BaseDao<Brand> {
	
	@Autowired
	public BrandDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找SKuEsVo的品牌部分数据
	 */
	public List<Integer> getProductIdByIds(List<String> ids) {
		return super.selectList("getProductIdByIds", ids);
	}
	
	/**
	 * 查找SKuEsVo的品牌部分数据
	 */
	public List<Map> getBrandInfoByIds(Collection<String> ids) {
		return super.selectList("getBrandInfoByIds", ids);
	}
	
	/**
	 * 查找要es sku要更新的品牌信息部分字段
	 */
	public List<Map> getBrandInfoBySkuCodes(List<String> skuCodes) {
		return super.selectList("getBrandInfoBySkuCodes", skuCodes);
	}
	
	/**
	 * 查找要es prod要更新的品牌信息部分字段
	 */
	public List<Map> getBrandInfoByProductId(Integer productId) {
		return super.selectList("getBrandInfoByProductId", productId);
	}
}