package com.thebeastshop.scm.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Label;

@DaoConfig(table = "label")
public class LabelDao extends BaseDao<Label>{
	
	@Autowired
	public LabelDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找es中的需要的数据按productId
	 */
	public List<Map> getEsLabelByProductId(Integer productId) {
		return super.selectList("getEsLabelByProductId", productId);
	}
}