package com.thebeastshop.scm.dao;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SoInvoiceInfo;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_so_invoice_info")
public class SoInvoiceInfoDao extends BaseDao<SoInvoiceInfo>{
	
	@Autowired
	public SoInvoiceInfoDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 根据订单id查询发票信息
	 * @param soId
	 * @return
	 */
	public SoInvoiceInfo findSoInvoiceInfoBySoId(Integer soId){
		return super.selectOne("findSoInvoiceInfoBySoId",soId);
	}
}