package com.thebeastshop.scm.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.WhInvOccupy;

@DaoConfig(table = "t_wh_inv_occupy")
public class InvOccupyDao extends BaseDao<WhInvOccupy>{
	
	@Autowired
	public InvOccupyDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 得到库存占用
	 */
	public int getInvOccupyQuantityBySkuCodesAndWarehouseCode(Collection<String> skuCodes, String wareHouseCode){
		Map parameter = new HashMap();
		parameter.put("wareHouseCode", wareHouseCode);
		parameter.put("skuCodes", skuCodes);
		return super.selectOne("getInvOccupyQuantityBySkuCodesAndWarehouseCode", parameter);
	}
	
}