package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ClPs.*;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ClPs;
import com.thebeastshop.scm.po.ClPs.ChangeSource;

@DaoConfig(table = "t_pcs_cl_ps")
public class ClPsDao extends BaseDao<ClPs>{
	
	@Autowired
	public ClPsDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<ClPs> limit(int limitSize){
		return super.selectList(new WhereBuilder().orderDesc(F_ID).limit(limitSize));
	}
	
	public List<ClPs> byChangeSource(ChangeSource changeSource){
		return super.selectList(new WhereBuilder(F_CHANGE_SOURCE, changeSource.value));
	}
	
	/**
	 * 删除小于或者等于maxId的记录
	 * @param maxId
	 * @return
	 */
	public int deleteMaxId(Integer maxId){
		return super.delete(new WhereBuilder().lte(F_ID, maxId));
	}
}