package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.SkuCategoryFrontRelation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.SkuCategoryFrontRelation;

@DaoConfig(table = "t_pcs_sku_category_front_relation")
public class SkuCategoryFrontRelationDao extends BaseDao<SkuCategoryFrontRelation>{
	
	@Autowired
	public SkuCategoryFrontRelationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 指量更新前端类目
	 */
	public int saveByListMap(List<Map> frontCategoryList) {
		List<SkuCategoryFrontRelation> list = new ArrayList<SkuCategoryFrontRelation>();
		for (Map frontCategoryMap : frontCategoryList) {
			String skuCode = MapUtils.getString(frontCategoryMap, "skuCode");
			Integer categroyId = MapUtils.getInteger(frontCategoryMap, "categoryId");
			SkuCategoryFrontRelation skuCategoryFrontRelation = this.selectOne(new WhereBuilder(F_SKU_CODE, skuCode).eq(F_CATEGORY_ID, categroyId));
			if (skuCategoryFrontRelation == null) {
				list.add(new SkuCategoryFrontRelation(skuCode, categroyId));
			}
		}
		if (CollectionUtils.isNotEmpty(list)) {
			return this.insertBatch(list);
		}
		return 0;
	}
	
	/**
	 * 是否是鲜花类目
	 */
	public boolean isFlowerBySkuCode(List<String> skuCodes) {
		List<SkuCategoryFrontRelation> list = super.selectList(new WhereBuilder(F_CATEGORY_ID, 119).in(F_SKU_CODE, skuCodes));
		return CollectionUtils.isNotEmpty(list);
	}
}