package com.thebeastshop.scm.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Supplier;

@DaoConfig(table = "t_pcs_supplier")
public class SupplierDao extends BaseDao<Supplier> {
	
	@Autowired
	public SupplierDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找SKuEsVo的分类部分数据
	 */
	public List<Map> getSupplierByIds(Collection<String> ids) {
		return super.selectList("getSupplierByIds", new ArrayList(ids));
	}
}