package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.SkuCategoryFront.*;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.SkuCategoryFront;

@DaoConfig(table = "t_pcs_sku_category_front")
public class SkuCategoryFrontDao extends BaseDao<SkuCategoryFront>{
	
	@Autowired
	public SkuCategoryFrontDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查所有类目主要类目和次级类目
	 */
	public List<Map> getProductEsFrontCategoriesBySkuCodes(List<String> skuCodes) {
		return super.selectList("getProductEsFrontCategoriesBySkuCodes", skuCodes);
	}
	
	
	public List<Map> getSkuEsVoFrontCategoriesBySkuCodes(String skuCode) {
		return super.selectList("getPcsSkuCategoryVOBySkuCodes", skuCode);
	}
	
	
	public List<Integer> getProductIdByIds(List<String> ids) {
		return super.selectList("getProductIdByIds", ids);
	}
	
	/**
	 * 得到前端类目id按(skuCode的查出的后端类目)
	 */
	public List<Map> getFrontCategoryIdsByBackSkuCode(List<String> skuCodes){
		return super.selectList("getFrontCategoryBySkuCode", skuCodes);
	}
	
}