package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Product.F_CODE;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.util.ObjUtils;
import pers.richard.ormybatis.util.ReflectUtil;

import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.po.Product;

@DaoConfig(table = "t_op_product")
public class ProductDao extends BaseDao<Product>{
	
	@Autowired
	public ProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Product byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}
	
	public List<Product> byProductIds(List<Integer> productIds){
		return super.selectList(new WhereBuilder().in(F_ID, productIds));
	}
	
	public List<String> getSkuCodeById(Integer id) {
		return super.selectList("getSkuCodeById", id);
	}
	
	public List<PsProductVO> getPsProductVOByIds(List<Integer> ids){
		return super.selectList("getPsProductVOByIds", ids);
	}
	
	public List<Integer> getAllProductId(){
		return super.selectFieldList("id", new WhereBuilder().gte("id", 0));
	}
	
	/**
	 * 查找所有新官网的上架的商品productId和skucode
	 * @return
	 */
	public List<Map> getAllProductIdAndSkuCodeByOnShelf(){
		return super.selectList("getAllIdAndSkuCodeByOnShelf");
	}
	
	/**
	 * 定时自动下架EMAIl内容
	 * @return
	 */
	public List<Map> mailContentByIds(List<Integer> productIds){
		return super.selectList("mailContentByIds", productIds);
	}
	
	/**
	 * PROD维护页面
	 */
	public List<Map> listProdMat(Map params){
		Integer page = MapUtils.getInteger(params, "page", 1);
		Integer size = MapUtils.getInteger(params, "size" , 20);
		if (page > 0) {
			page -- ;
		}
		int start = page * size;
		params.put("start", start);
		return super.selectList("listProdMat", params);
	}
	
	/**
	 * 是否来单制作
	 * @return ture:来单制作 false:不是来单制作
	 */
	public boolean isJitById(Integer productId){
		Integer result = super.selectOne("isJitById", productId);
		return result != null;
	}
	
	public static void main(String[] args) {
		// test...111
	}
}