/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.merchandise.cond.InvHomeSkuCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCollectionCond;
import com.thebeastshop.pegasus.merchandise.cond.OpDiffChangeSkuCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCustomBckSearchCond;
import com.thebeastshop.pegasus.merchandise.vo.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Eric.Lou
 * @version $Id: McPcsSkuService.java, v 0.1 2015-08-03 下午06:13
 */
public interface McPcsSkuService {


    /**
     * 创建sku
     *
     * @param
     * @return
     */
    Long create(PcsSkuVO vo);

    void updateAuditData(String skuCode);

    /**
     * 批量创建SKU
     *
     * @param list
     * @return
     */
    List<Long> createSkus(List<PcsSkuVO> list);

    List<PcsSkuVO> batchCreateSku(List<PcsSkuVO> list);

    Long saveFlowerSku(McPcsFlowerSkuVO vo);

    List<McPcsFlowerSkuVO> batchSaveFlowerSku(List<McPcsFlowerSkuVO> list);

    List<PcsSkuVO> findSkuByName(List<String> nameList);

    void saveFlowerSkuDayMaintain(List<PcsSkuDayMaintainVO> maintainList);

    List<PcsSkuDayMaintainVO> modifyFlowerSkuShelfStatus(List<String> skuCodes, Integer skuShelfStatus);

    List<PcsSkuDayMaintainVO> findSkuDayMaintainBySupplierId(Long supplierId);

    List<PcsSkuDayMaintainVO> findLatestMaintainInfo(List<String> skuCodes, Date expectDate);

    List<PcsSkuDayMaintainVO> findMaintainInfoBySkuCode(List<String> skuCodes);

    Pagination<McPcsFlowerSkuVO> findFlowerSkuByCondPage(PcsSkuCond cond);

    List<McPcsFlowerSkuVO> findFlowerSkuByCond(PcsSkuCond cond);

    McPcsFlowerSkuVO findFlowerSkuByCode(String code);
    /**
     * 更新sku
     *
     * @return
     */
    boolean update(PcsSkuVO vo);

    void savePcsSkuBarcode(String skuCode, String barcode, boolean selective);

    /**
     * 保存定制信息
     *
     * @param customizeVO
     * @return
     */
    boolean saveSkuCustomizeInfo(PcsCustomizeVO customizeVO);
    List<Long> copyCustomizeSku(PcsCustomizeVO customizeVO);

    /**
     * 根据主键查找sku
     *
     * @param id
     * @return
     */
    PcsSkuVO findById(long id);

    /**
     * 根据CODE查找sku
     *
     * @param code
     * @return
     */
    PcsSkuVO findByCode(String code);

    List<String> findAllGiftSkuCodes();

    PcsSkuVO findByCodeOrBarcodeOrSupplierSkuBarcode(String codeOrBarcode);

    PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories);

    PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName);

    List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode);

    Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode);

    /**
     * 根据参数查找sku
     *
     * @param nameCode
     * @return
     */
    List<PcsSkuVO> findByNameOrCode(String nameCode);

    List<PcsSkuVO> findByNameOrCodeOrSupplierCode(String nameCode);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCond(PcsSkuCond cond);

    PageQueryResp<PcsSkuVO> listSkuByCond(PcsSkuCond cond);


    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCondForInvHome(InvHomeSkuCond cond);

    /**
     * 根据条件统计sku
     *
     * @param cond
     * @return
     */
    Integer countByCondForInvHome(InvHomeSkuCond cond);

    /**
     * 查询审核中的sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findAuditSkuByCond(PcsSkuCond cond);

    /**
     * 查询审核中的sku数量
     *
     * @param cond
     * @return
     */
    Integer countAuditSkuByCond(PcsSkuCond cond);

    /**
     * 关务审批查询
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findCustomsAuditSkuByCond(PcsSkuCond cond);

    /**
     * 自进口SKU查询
     *
     * @param cond
     * @return
     */
    PageQueryResp<PcsSkuVO> findOwnImportSkuByCond(PcsSkuCond cond);


    List<PcsSkuVO> findCustomBackRcdForExportExcel(PcsSkuCustomBckSearchCond cond);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuRangeStructureByCond(PcsSkuCond cond);


    /**
     * 根据条件查找sku
     * 导出使用
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCondForExport(PcsSkuCond cond);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond);

    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    Boolean canUpdateSkuSalesPrice(String code);

    /**
     * 售价变更审批
     *
     * @return
     */
    Boolean auditSkuSalesPriceChange(PcsSkuAuditVO skuAudit);

    /**
     * 根据skucode查找 审批中的售价变更记录
     *
     * @param code
     * @return
     */
    /*PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code);*/

    /**
     * 根据CODE集合查找sku
     *
     * @param codes
     * @return
     */
    List<PcsSkuVO> findSkuByCodes(List<String> codes);
    List<PcsSkuVO> findSkuByCategoryIds(List<Long> categoryIds);

    List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories);

    List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories, boolean witBarcode);

    List<PcsSkuVO> findSkuByCodeByCond(PcsSkuCond skuCond);

    List<PcsSkuSuiteVO> listPcsSkuSuiteVOByCond(PcsSkuCond skuCond);

    List<PcsSkuSuiteVO> listPcsSkuSuiteVOBySuiteIds(List<Integer> suiteIds);

    List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories);

    /**
     * 转换sku
     *
     * @param sku
     * @param skuCustomMadeId
     * @return
     */
    Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId);

    /**
     * 转移sku
     */
    boolean transferSku(List<String> skuCodes, Long buyerId);


    /**
     * 所有SKU信息
     *
     * @return
     */
    List<PcsSkuInfoVO> allSkuInfo();

    /**
     * 所有SKU信息
     *
     * @return
     */
    PcsSkuInfoVO findStockByCode(String skuCode);

    List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond);

    void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId);

    List<PcsSkuVO> findSkuByIds(List<Long> ids);

    Boolean canUpdateCostPrice(String code);

    Boolean canUpdateSupplier(String code);

    /**
     * sku总数计算
     *
     * @param cond
     * @return
     */
    long countSkuByCond(PcsSkuCond cond);

    String getCrossBorderFlagByCodes(List<String> codes);

    Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode);

    List<Integer> getSalesPriceByCodes(List<String> codes);

    public List<Map> getSalesPriceByProdId(Long prodId);

    List<PcsSkuVO> findSkuAuditByIds(List<Long> ids);

    List<PcsSkuBarcodeVO> selectByBarCode(String barCode);

    List<PcsSkuVO> findSkuBySupplierId(Long supplierId);

    /**
     * 更新成品成本
     *
     * @param vo
     * @return
     */
    boolean updatePrdcRecipeSkuCost(PcsSkuVO vo);

    /**
     * 只更新sku数据
     *
     * @param vo
     * @return
     */
    int updateSku(PcsSkuVO vo);
    int updateSkuConfigIpCooperate(PcsSkuConfigItemsDTO vo);
    int updateSkuConfigItmes(PcsSkuConfigItemsDTO vo);

    boolean skuBarcodeModify(List<PcsSkuBarcodeModifyVO> dataList);

    boolean costPriceNeedApproval(PcsSkuVO vo);

    public Integer getMonthlyByCodes(List<String> skuCodes);

    List<PcsSkuVO> findSkuQualifyByCond(PcsSkuCond cond);

    List<PcsSkuVO> findSkuQualifyByInCond(PcsSkuCond cond);

    List<PcsSkuVO> findSharedImportDoc();

    List<PcsSkuVO> findSharedAptitude();

    void autoUpdateServiceLevel();

    Map<String, PcsSkuDTO> getSkuNameByCodes(Set<String> skuCodes);

    PcsSkuConfigItemsDTO findSkuConfigItemsBySkuCode(String skuCode);
    PcsSkuAttributesVO findSkuAttributesBySkuCode(String skuCode);

    List<PcsSkuAttributesVO> findSkuAttributesBySkuCode(List<String> skuCodeList);

    List<PcsSkuAttributesVO> findSkuAttributesByChineseProductName(List<String> nameList);

    List<PcsSkuConfigItemsDTO> findSkuConfigItemsBySkuCode(List<String> skuCodes);

    PcsSkuPlanningVO findSkuPlanningInfoBySkuCode(String skuCode);

    List<PcsSkuPlanningVO> findSkuPlanningInfoBySkuCode(List<String> skuCodeList);

    List<PcsSkuAuditRecordsVO> findAuditRecordsByCodeAndStatus(String skuCode, Integer auditStatus);

    /**
     * 获取 最新审核通过的审核记录
     *
     * @param skuCode
     * @return
     */
    PcsSkuAuditRecordsVO findLatestReviewPassedRecord(String skuCode);

    Map<String, PcsSkuAuditRecordsVO> mapAuditRecordsByCodeAndStatus(List<String> skuCodeList, Integer auditStatus);

    PcsSkuAuditRecordsVO findAuditRecordsByCodeAndProcessing(String skuCode);


    /**
     * 关务审批SKU
     *
     * @param pcsSkuVO
     * @param isPass
     * @param remark
     * @return
     */
    boolean customsAuditSku(PcsSkuVO pcsSkuVO, boolean isPass, String remark);

    List<PcsSkuVO> findSkuByTaxIdList(List<String> taxIdList);

    int updateSkus(List<PcsSkuVO> list);


    /**
     * 查询正在审核中的审核记录(SKU只能有一条审核中的记录)
     *
     * @param skuCode
     * @return
     */
    PcsSkuAuditRecordsVO findProcessingAuditBySkuCode(String skuCode);
    List<PcsSkuAuditRecordsVO> findProcessingAuditBySkuCode(List<String> skuCodeList);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoBySkucodes(List<String> skuCodeList);

    PcsSkuCustomsInfoVO findCustomsInfoBySkucode(String skuCode);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoByRecordNos(List<String> recordNoList);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoByItemNumbers(List<String> itemNumberList);

    int batchInsertOrUpdateRecordNo(List<PcsSkuCustomsInfoVO> customsInfoList);

    List<String> refreshSkuData();

    Map<String, PcsSkuBarcodeVO> findBarcodeBySkuCodes(List<String> skuCodes);

    /**
     * planning 修改sku信息
     *
     * @param planningInfo
     * @return
     */
    int planningToEditSku(PcsSkuPlanningVO planningInfo);

    int planningToEditSku(List<PcsSkuPlanningVO> planningInfoList);

    List<PcsSkuDTO> listSkuByCategoryIds(List<Long> categoryIds);

    Map<String, PcsSkuVO> mapSkuInfoByBarcodes(List<String> barcodes);

    Map<String, PcsSkuVO> mapSkuByCodes(List<String> skuCodes);

    PcsSkuCustomVO findCustomSkuDetailBySkuCode(String skuCode);

    int saveOrUpdateItemNumber(String skuCode);

    int updateSkuCustomInfo(PcsSkuCustomsInfoVO pcsSkuCustomsInfo);

    List<PcsSkuVO> findSkuTagAndBrandByCodes(List<String> skuCodes);

    /**
     * 撤销审批
     *
     * @param skuCode
     * @return
     */
    int withdrawApproval(String skuCode);

    boolean checkSkuPermission(String skuCode, boolean oemQuery, Long loginId);

    List<String> checkSkuPrice(Map<String, BigDecimal> skuCodePriceMap);

    Boolean cancelCreate(PcsSkuVO vo);

    /**
     * 查询sku 审批log 按需发送通知
     *
     * @param notifyType
     * @return
     */
    List<PcsSkuAuditLogsVO> findAuditLogsForNotify(int notifyType);

    /**
     * 设置审批 通知状态
     *
     * @param ids
     * @return
     */
    int setAuditNotifyStatus(List<Long> ids);

    int setQaSpecial(String skuCode);

    /**
     * 设置售价变更通知状态
     *
     * @param ids
     * @return
     */
    int setSalesPriceChangeNotifyStatus(List<Long> ids);

    /**
     * 获取 没有发送过通知的售价变更记录
     *
     * @return
     */
    List<PcsSkuSalesPriceChangeLogVO> listNotNotifySkuSalesPriceChangeLog();

    PageQueryResp<PcsSkuPendingApprovalVO> listPendingApprovalRecord(PcsSkuCond cond);

    /**
     * 模糊匹配collection
     * @param collectionName
     * @return
     */
    List<PcsSkuCollectionVO> findCollection(String collectionName, boolean isLike, Boolean isUsable);

    List<PcsSkuCollectionVO> listCollectionByName(List<String> collectionNameList, Boolean isUsable);

    List<PcsSkuSubCollectionVO> listSubCollectionByName(List<String> subCollectionNameList, Boolean isUsable);
    List<PcsSkuSubCollectionVO> listSubCollectionByCollectionId(List<Integer> collectionIdList, Boolean isUsable);

    List<PcsSkuSubCollectionVO> findSubCollection(Integer collectionId, String subCollectionName, boolean isLike, Boolean isUsable);
    Map<Integer, PcsSkuSubCollectionVO> mapSubCollection(List<Integer> subCollectionIdList);
    PcsSkuSubCollectionVO getSubCollection(Integer subCollectionId);
    Map<Integer, PcsSkuCollectionVO> mapCollection(List<Integer> collectionIdList);
    List<PcsSkuSubCollectionVO> getCollectionDictionary();
    PcsSkuCollectionVO findSkuCollectionById(Integer collectionId, boolean cascadeSub);
    List<PcsSkuCollectionVO> listAllCollection();
    List<PcsSkuSubCollectionVO> listSubSkuCollectionByCollectionId(Integer collectionId);
    int saveSkuCollection(PcsSkuCollectionVO skuCollectionVO);
    Pagination<PcsSkuSubCollectionVO> pageListSkuCollection(PcsSkuCollectionCond cond);
    boolean setCollectionStatus(Integer collectionId, Integer subCollectionId, boolean isUsable);


    /**
     * 不同sku换货 sku参数查询
     * @param cond
     * @return
     */
    List<PcsSkuVO> findExchangeDiffSkuByParams(OpDiffChangeSkuCond cond);

    /**
     * 保存组合信息
     * @return
     */
    int saveSkuSuite(String skuCode, List<PcsSkuSuiteVO> suiteList);

    List<PcsSkuSuiteVO> listSkuSuite(String skuCode);

    List<PcsSkuSuiteVO> listSkuSuite(List<String> skuCodes, List<Integer> suiteIds);

    int getPermissionType(Long operatorId);

    /**
     * 保存阶梯成本
     * @param skuCode
     * @param skuLadderCostList
     * @return
     */
    int saveSkuLadderCost(String skuCode, List<PcsSkuLadderCostVO> skuLadderCostList);

    int saveSkuLadderCost(String skuCode, PcsSkuLadderCostExtendVO skuLadderCostExtendVO);
    int saveSkuAttributes(String skuCode, PcsSkuAttributesVO skuAttributes);
    int saveSkuSupplierManufacturer(String skuCode, List<PcsSkuSupplierManufacturerVO> supplierManufacturerList);

    PcsSkuVO findBySkuCode(String skuCode);
    PcsSkuLadderCostExtendVO findLadderCostInfo(String skuCode);
    PcsSkuAuditChangeVO getAuditChangeInfo(String skuCode);
    List<PcsSkuAuditChangeVO> getAuditChangeInfo(List<String> skuCodeList);

    /**
     * 逻辑删除SKU
     * @param skuCode
     * @return
     */
    boolean deleteSku(String skuCode);
    List<PcsSkuSupplierManufacturerVO> getSkuSupplierManufacturer(String skuCode);
    List<PcsSkuSupplierManufacturerVO> getSkuSupplierManufacturer(List<String> skuCodeList);
    List<String> listCategoryProductType(Long categoryId);

}
