/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.utils.EmptyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PcsSkuTypeEnum {
    RAW_MATERIAL(1, "\u539f\u6750\u6599"),
    SEMI_FINISHED_PRODUCT(2, "\u534a\u6210\u54c1"),
    FINISHED_PRODUCT(3, "\u6210\u54c1");

    public final Integer status;
    public final String desc;
    public static final List<PcsSkuTypeEnum> ALL;

    private PcsSkuTypeEnum(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static final List<Map<String, Object>> listMapEnum() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (PcsSkuTypeEnum skuTypeEnum : ALL) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", skuTypeEnum.status);
            map.put("name", skuTypeEnum.desc);
            list.add(map);
        }
        return list;
    }

    public static String getDesc(Integer status) {
        if (status == null) {
            return "";
        }
        for (PcsSkuTypeEnum c : ALL) {
            if (!c.getStatus().equals(status)) continue;
            return c.desc;
        }
        return null;
    }

    public static Integer getType(String desc) {
        if (EmptyUtil.isNotEmpty((String)desc)) {
            for (PcsSkuTypeEnum c : ALL) {
                if (!c.desc.equals(desc)) continue;
                return c.status;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(PcsSkuTypeEnum.values()));
    }
}

