package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 商品属性VO
 * @author gongjun
 * @since 2016-10-13
 */
public class OpAttributeVO implements Serializable {

    private Long id;

    /**
     * SPU ID
     */
    private Long productId;

    /**
     * 是否为组合属性
     */
    private Integer combined;

    /**
     * 组名称
     */
    private String groupName;

    /**
     * 名称
     */
    private String name;

    private String attrName1;
    private String attrName2;
    private String attrName3;

    /**
     * 属性值列表
     */
    private List<OpAttributeValueVO> attributeValueList;

    /**
     * 属性值Map {属性值文本 -> OpAttributeValueVO}
     */
    private Map<String, OpAttributeValueVO> attributeValueMap = new LinkedHashMap<>();

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Integer getCombined() {
        return combined;
    }

    public void setCombined(Integer combined) {
        this.combined = combined;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<OpAttributeValueVO> getAttributeValueList() {
        return attributeValueList;
    }

    public void setAttributeValueList(List<OpAttributeValueVO> attributeValueList) {
        this.attributeValueList = attributeValueList;
    }

    public Map<String, OpAttributeValueVO> getAttributeValueMap() {
        return attributeValueMap;
    }

    public void setAttributeValueMap(Map<String, OpAttributeValueVO> attributeValueMap) {
        this.attributeValueMap = attributeValueMap;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getAttrName1() {
        return attrName1;
    }

    public void setAttrName1(String attrName1) {
        this.attrName1 = attrName1;
    }

    public String getAttrName2() {
        return attrName2;
    }

    public void setAttrName2(String attrName2) {
        this.attrName2 = attrName2;
    }

    public String getAttrName3() {
        return attrName3;
    }

    public void setAttrName3(String attrName3) {
        this.attrName3 = attrName3;
    }
}
