package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSpecialVarietyEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


public class PsSpvBaseVO implements Serializable {

    private Long spvId;
    /**
     * 组合原价
     */
    private BigDecimal originalPrice;
    /**
     * 售价
     */
    private BigDecimal salesPrice;

    /**
     * PRODUCT ID
     */
    private Long productId;
    /**
     * PRODUCT编码
     */
    private String productCode;
    /**
     * PRODUCT名称
     */
    private String productName;
    /**
     * 成本价
     */
    private BigDecimal costPrice;
    /**
     * 是否组合
     */
    private Boolean combined;


    /**
     * 最小起售数
     */
    private Integer minAmount;

    /**
     * 单品SKU CODE
     */
    private String skuCode;
    private String barCode;

    /**
     * 单品SKU
     */
    private PsSkuBaseVO skuVO;

    /**
     * SKU组合列表
     */
    private List<PsSkuCombinationVO> skuCombinationList;

    /**
     * 预告活动价格
     */
    private BigDecimal advancePrice;
    /**
     * SKU维度活动列表
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();


    /**
     * 预告活动
     */
    private List<PsCampaignVO> advanceCampaignList = new ArrayList<>();




    private Boolean isNewMember = false;//是否是新人专享

    /**
     * 非组合商品后端主类目编号
     */
    private Long categoryId;

    private String bu;

    private Integer customPrintTemplate;//0:不支持 1:吊牌定制


    /**
     * 是否来单
     */
    private Boolean isJit;



    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }


    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }






    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public PsSkuBaseVO getSkuVO() {
        return skuVO;
    }

    public void setSkuVO(PsSkuBaseVO skuVO) {
        this.skuVO = skuVO;
    }

    public List<PsSkuCombinationVO> getSkuCombinationList() {
        return skuCombinationList;
    }

    public void setSkuCombinationList(List<PsSkuCombinationVO> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public BigDecimal getAdvancePrice() {
        return advancePrice;
    }

    public void setAdvancePrice(BigDecimal advancePrice) {
        this.advancePrice = advancePrice;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<PsCampaignVO> getAdvanceCampaignList() {
        return advanceCampaignList;
    }

    public void setAdvanceCampaignList(List<PsCampaignVO> advanceCampaignList) {
        this.advanceCampaignList = advanceCampaignList;
    }




    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getCustomPrintTemplate() {
        return customPrintTemplate;
    }

    public void setCustomPrintTemplate(Integer customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }



    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }



    public Boolean getIsNewMember() {
        return isNewMember;
    }

    public void setIsNewMember(Boolean isNewMember) {
        this.isNewMember = isNewMember;
    }

    public Boolean getIsJit() {
        return isJit;
    }

    public void setIsJit(Boolean isJit) {
        this.isJit = isJit;
    }


}
