package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.hotlink.annotation.Hotlink;
import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.vo.OpProdCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;

import java.util.List;
import java.util.Map;

/**
 * Created by QTJ on 2017/6/12.
 */
public interface McPcsCopywriterService {
    Long addCopywriter(PcsCopywriterVO copywriterVO);

    int updateCopywriter(PcsCopywriterVO copywriterVO);

    int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate);

    PcsCopywriterVO findCopywriterById(Long id);

    /**
     * 根据CopywriterCode查询Product
     * @param cond
     * @return
     */
    List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond);

    int deleteProdCopywriterByIds(List<String> idList);

    //列表查询
    List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond);


    /**
     * 检查商品在是否和已存在的商品(待生效或已生效的文案)时间上有交集  返回有交集的文案
     * @param cond
     * @return
     */
    List<PcsCopywriterVO> checkProductIsExistValidCopyWriter(PcsCopywriterCond cond);

    ProdSkuVO queryProductByProdCode(String prodCode);

    //更新文案状态
    void updateCopywriterValidStatus();

    /**
     * 通过ProdCodes查询 可以使用的文案
     * @param codes
     * @return
     */
    @Hotlink
    Map<String,ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes);

    /**
     * 更新商品文案表
     */
    void updateActiveCopywriter();

    /**
     *更新文案表
     */
    void updateValidStatus();

    ServiceResp<Integer> addProdCopywriterList(List<OpProdCopywriterVO> list);
    ServiceResp batchAddProdCopywriterList(List<PcsCopywriterVO> copywriterList,List<Long> delProdCopywriterIds);
    ServiceResp<List<PcsCopywriterVO>> getCopyWriterList(List<String> productCodeList);

}
