package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.pegasus.merchandise.cond.OpProdDynmAuditLogCond;
import com.thebeastshop.pegasus.merchandise.exception.DynmDetailsException;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailAuditLogVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsLogVO;

import java.util.Collection;
import java.util.List;

public interface McOpProdDynmcontDetailsAuditService {
    /**
     * 翻页查询动态内容审核记录
     * @param opProdDynmAuditLogCond
     * @return
     */
    public PageQueryResp<OpProdDynmDetailAuditLogVO> queryProdDynmDetailAuditLogByPage(OpProdDynmAuditLogCond opProdDynmAuditLogCond);
    /**
     * 查看动态内容变更记录
     * @param auditLogId
     * @return
     */
    public List<OpProdDynmDetailsLogVO> queryDynmDetailsLogByAuditLogId(String auditLogId);

    /**
     * 批量审核变更记录
     * @param opProdDynmDetailAuditLogVO
     * @return
     */
    public void batchUpdateAuditLog(OpProdDynmDetailAuditLogVO opProdDynmDetailAuditLogVO) throws DynmDetailsException;

    /**
     * 批量新增动态内容变更记录
     * @param auditLogVos
     * @return
     */
    public void markDynmDetailsAuditLogs(Collection<OpProdDynmDetailAuditLogVO> auditLogVos)throws DynmDetailsException;

}
