/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.common.enums.YesOrNoEnum;
import com.thebeastshop.common.utils.*;
import com.thebeastshop.pegasus.merchandise.constants.PcsSkuConstants;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuProductTypeEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuPurchaseStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuStatusEnum;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.wms.vo.KeyValueVO;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuVO.java, v 0.1 2015-08-03 18:17
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsSkuVO implements Serializable {

    /**
     * sku状态~价格待品类经理审核
     */
    public static final Integer SKU_STATUS_WAITING_VERIFY = 1;
    public static final Integer SKU_STATUS_DRAFT = 0;
    /**
     * sku状态~已驳回
     */
    public static final Integer SKU_STATUS_REJECT = 2;
    /**
     * sku状态~可用
     */
    public static final Integer SKU_STATUS_ABLE = 9;
    public static final Integer SKU_TYPE_FINISHED_PRODUCT = 3;
    /**
     * 产品重要性等级(1,2,3,4)
     */
    public static final Integer SERVICE_LEVEL_1 = 1;
    public static final Integer SERVICE_LEVEL_2 = 2;
    public static final Integer SERVICE_LEVEL_3 = 3;
    public static final Integer SERVICE_LEVEL_4 = 4;
    private static final long serialVersionUID = 1L;
    public Long buyerId;
    //操作来源（1:页面创建更新,2: Excel批量操作）
    private Short optSource = 1;

    /* @ExcelColumn(name="sku销售名")
     private String nameSale;*/
    // original
    private Long id;
    private String merchantCode;
    @ExcelColumn(name = "skucode")
    private String code;
    @ExcelColumn(name = "备案海关")
    private String customsName;
    private Date createTime;
    private Integer skuStatus;
    @ObjectChangeLog(name = "SKU状态")
    private String skuStatusDesc;
    @ExcelColumn(name = "sku中文名")
    @NotNull
    @ObjectChangeLog(name = "sku中文名")
    private String nameCn;
    @ExcelColumn(name = "sku英文名")
    @ObjectChangeLog(name = "sku英文名")
    private String name;
    @ExcelColumn(name = "供应商编号")
    @Min(value = 0)
    @NotNull
    private Long defaultSupplierId;
    private Long oldSupplierId;
    private String oldSupplierNameCn;
    @ExcelColumn(name = "品牌编号")
    @Min(value = 0)
    @NotNull
    private Long brandId;
    @ExcelColumn(name = "品类编号")
    @Min(value = 0)
    @NotNull
    private Long categoryId;
    //审批中的品类ID
    private Long newCategoryId;
    private List<Long> secondaryCategoryIds;
    private List<PcsSkuCategoryVO> secondaryCategoryList;
    private String supplierProductCode;
    @ExcelColumn(name = "sku类型")
    @NotNull
    @ObjectChangeLog(name = "SKU类型")
    private String skuTypeName;
    private Integer whetherConsignment;
    @ExcelColumn(name = "采购模式")
    @NotNull
    @ObjectChangeLog(name = "采购模式")
    private String whetherConsignmentName;
    private BigDecimal costPrice;
    @ExcelColumn(name = "售价")
    @Min(value = 0)
    @NotNull
    @ObjectChangeLog(name = "售价")
    private BigDecimal salesPrice;
    private BigDecimal oldSalesPrice;
    @Min(value = 0)
    @NotNull
    @ExcelColumn(name = "最小订货量")
    @ObjectChangeLog(name = "最小订货量")
    private Integer moq;
    @ExcelColumn(name = "交期")
    @NotNull
    @ObjectChangeLog(name = "交期")
    private Integer deliveryPeriod;
    @ExcelColumn(name = "销售开始时间")
    @NotNull
    @ObjectChangeLog(name = "销售开始时间")
    //@DateTimeFormat(iso= DateTimeFormat.ISO.DATE)
    private Date saleStartDate;
    //@DateTimeFormat(iso= DateTimeFormat.ISO.DATE)
    @ExcelColumn(name = "销售结束时间")
    @NotNull
    @ObjectChangeLog(name = "销售结束时间")
    private Date saleEndDate;
    @ExcelColumn(name = "产地-国家")
    @NotNull
    @ObjectChangeLog(name = "产地-国家")
    private String placeOfOrigin;
    @ExcelColumn(name = "材质")
    @NotNull
    @ObjectChangeLog(name = "材质")
    private String material;
    @ObjectChangeLog(name = "规格")
    @ExcelColumn(name = "规格")
    @NotNull
    private String specification;
    @ExcelColumn(name = "尺寸")
    @NotNull
    @ObjectChangeLog(name = "尺寸")
    private String size;
    @ExcelColumn(name = "箱规")
    @NotNull
    @ObjectChangeLog(name = "箱规")
    private Integer preBoxNum;
    private Integer isJit;
    @ExcelColumn(name = "是否来单定制")
    @NotNull
    @ObjectChangeLog(name = "是否来单定制")
    private String isJitName;
    //@ExcelColumn(name="是否跨境购")
    private String crossBorderName;
    @ExcelColumn(name = "毛重")
    @ObjectChangeLog(name = "毛重")
    private String weight;
    @ExcelColumn(name = "净重")
    @ObjectChangeLog(name = "净重")
    private BigDecimal netWeight;

    // 默认发货仓1.香港仓 2.深圳仓
    private Integer defaultWarehouse;

    // 1:易碎，0：非易碎
    private Boolean fragile;

    // 商品类型（1：普通商品，2:赠品，3：样品）
    private Integer productType;

    private Long creatorId;

    @ExcelColumn(name = "用途")
    @ObjectChangeLog(name = "用途")
    private String purpose;
    @ExcelColumn(name = "通关方式")
    @ObjectChangeLog(name = "通关方式")
    private String clearanceWayCN; //通关方式中文描述
    //@ExcelColumn(name="行邮税号")
    @ObjectChangeLog(name = "行邮税号")
    private String taxNo;
    //@ExcelColumn(name="HS编号")
    @ObjectChangeLog(name = "HS编号")
    private String goodsHscode;
    //@ExcelColumn(name="增值税率")
    @ObjectChangeLog(name = "增值税率")
    private BigDecimal vatRate;
    //@ExcelColumn(name="消费税")
    @ObjectChangeLog(name = "消费税")
    private BigDecimal saleTax;
    @ExcelColumn(name = "实际商品计量单位")
    @ObjectChangeLog(name = "实际商品计量单位")
    private String goodsUnitcode;
    private String goodsOriginCountryCode;
    //@ExcelColumn(name="商品法定计量单位代码")
    @ObjectChangeLog(name = "商品法定计量单位")
    private String goodsLegalUnitcode;
    //@ExcelColumn(name="法定计量单位下的商品数量")
    @ObjectChangeLog(name = "增值税率")
    private Float goodsLegalUnitQuantity;
    //@ExcelColumn(name="第二法定计量单位")
    @ObjectChangeLog(name = "第二法定计量单位")
    private String secondLegalUnitcode;
    //@ExcelColumn(name="第二法定计量单位下的商品数量")
    @ObjectChangeLog(name = "第二法定计量单位下的商品数量")
    private Float secondLegalUnitQuantity;
    @ObjectChangeLog(name = "图片")
    private String skuImg;
    @ExcelColumn(name = "是否自产")
    @NotNull
    @ObjectChangeLog(name = "是否自产")
    private String isMadeBySelfName;
    @ExcelColumn(name = "是否进口")
    @NotNull
    @ObjectChangeLog(name = "是否进口")
    private String isImportedName;
    @ExcelColumn(name = "虚拟商品")
    @ObjectChangeLog(name = "虚拟商品")
    @NotNull
    private String whetherVirtual;
    @ExcelColumn(name = "是否大家具")
    @ObjectChangeLog(name = "是否大家具")
    @NotNull
    private String whetherLogistics;
    @ExcelColumn(name = "平均物流运费（元）")
    @ObjectChangeLog(name = "物流运费")
    private BigDecimal averageLogisticsCosts;
    @ExcelColumn(name = "安装服务")
    @ObjectChangeLog(name = "安装服务")
    private String installService;
    //新平均物流运费（审批中的）
    private BigDecimal newAverageLogisticsCosts;
    private Integer whetherVipDisdount;
    /*   @ExcelColumn(name="是否VIP折扣")
       @NotNull
       private String whetherVipDisdountName;*/
    @ObjectChangeLog(name = "采购状态")
    private Integer canPurchase;
    // 是否可定制
    private Integer canCustomize;
    private List<Integer> customizeTypeList;
    private String customizeType;
    @ExcelColumn(name = "买手")
    @NotNull
    @ObjectChangeLog(name = "买手")
    private String buyRealName;
    private String level1CategoryName;
    private String level1SkucategoryFullName;
    private List<PcsSkuCategoryVO> frontCategoryList;
    private List<PcsSkuCategoryVO> backCategoryList;
    private String skuTypeStr;
    private String buyerEmail;//买手邮箱
    private String skuCustomMadeCode;
    private String combinedSkuRecipeCode;
    private Integer skuType;
    private String ean13;
    private Integer isMadeBySelf;
    @ExcelColumn(name = "供应商产品编码")
    @ObjectChangeLog(name = "供应商产品编码")
    private String barcode;


    private boolean autoDistBarcode;//自动分配供应商编码

    private Integer unbindDistBarcode;//解绑自动分配供应商编码
    private String supplierBarcode;
    private Integer isImported;
    // 是否自进口
    private Integer isOwnImported;
    @ExcelColumn(name = "是否自进口")
    @ObjectChangeLog(name = "是否自进口")
    private String isOwnImportedName;
    // 资质审批状态
    private Integer qualifyAuditStatus;
    // 资质审批流程
    private Integer qualifyFlowTrend;
    // 资质文件是否需要后补
    private Integer isPostMeeting;
    // 资质审批ID
    private Long qualifyId;
    // 资质审批结果
    private Integer auditDecision;
    private Integer prepareDays;
    //barcode 列表
    private List<PcsSkuBarcodeVO> barcodeList;
    private Integer selectDeliveryDays;
    private Integer isDeliveriedByStore;
    private String deliveryStores;
    private Integer pictureFileId;
    @ExcelColumn(name = "备注")
    private String remark;
    @ExcelColumn(name = "工艺描述")
    private String processDescription;
    private String purchaseRemark;
    private String buyerName;
    private List<PcsWatermarkVO> watermarkList;
    private String watermarkCodesJson;
    private List<PcsTagVO> tagList;
    private String tagCodesJson;
    /**
     * 积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
     */
    private Integer pointDeductRule;
    /**
     * 积分抵扣使用积分
     */
    private BigDecimal pointDeductPoint;
    /**
     * 积分抵扣后金额
     */
    private BigDecimal pointDuductPrice;
    /**
     * sku分类名
     */
    private String skuCategoryName;
    /**
     * 是否可以备注
     */
    private Integer canRemark;
    @ExcelColumn(name = "保质期")
    @ObjectChangeLog(name = "保质期")
    private Integer shelfLife;
    @ExcelColumn(name = "建议包装方案")
    @ObjectChangeLog(name = "建议包装方案")
    private String suggestPackage;
    // self
    private String pictureFileName;
    private String supplierName;
    @ObjectChangeLog(name = "供应商")
    private String supplierNameCn;
    private String categoryName;
    private String newCategoryName;
    @ObjectChangeLog(name = "品类")
    private String skucategoryFullName;
    //审批中的品类名
    private String newCategoryFullName;
    private String brandName;
    @ObjectChangeLog(name = "品牌")
    private String brandNameCn;
    private Long brandCountryId;
    private String brandCountryName;
    private Integer canCustomizeSalesPrice = 0;
    /* @ExcelColumn(name="产品重要性等级")
     @NotNull
     @Min(value = 1)
     @Max(value = 4)*/
    private Integer serviceLevel;
    //@ExcelColumn(name="执行标准")
    private String executingStandard;
    private Integer crossBorderFlag;
    private Integer myIsJit;
    private Integer myCrossBorderFlag;
    private Integer myCanPurchase;
    private Integer quantity;
    /*库存*/
    private Integer stock;
    private Integer storageType;
    /**
     * 标签id
     */
    private Integer tagId;
    /**
     * 是否已有标签：0没有1有
     */
    private Integer isHasTag;
    /**
     * 审核状态：0取消1通过2特殊放行3未审核
     */
    private Integer checkStatus;
    /**
     * 是否提交：0没提交1已提交
     */
    private Integer isSubmit = 0;
    // 中文标签状态 是否提交 [1已提交 0未提交]
    private Integer cerIsSubmit;
    // 中文标签风险等级 [1无风险 2低风险 3高风险]
    private Integer cerCheckStatus;
    /**
     * 合格证尺寸
     */
    private Integer certificateSize;
    /**
     * 采购员
     */
    private String realName;
    /**
     * 标签最近更新时间
     */
    private Date tagLastUpdateTime;
    //1: 只更新，不生成审核记录
    private int optType;
    private BigDecimal oldCostPrice;
    //首次售价审核是否通过
    private Boolean firstAuditPass;
    private Integer clearanceWay; //通关方式
    //是否批量更新
    private Boolean batchUpdate = false;
    private Short skuAuditStatus;
    private BigDecimal customizationPrice;
    private Date lastAuditTime;
    private Date lastSubmitTime;
    private String lastApproverName;
    private String lastAuditRemark;
    private Integer lastApprover;
    private PcsCustomizeVO customizeVO;
    /* @ExcelColumn(name = "是否周送鲜花")
     @NotNull*/
    private String isMonthSendDesc;
    private Integer isMonthSend;
    /* @ExcelColumn(name = "配送时间（1代表星期一  以此类推）")*/
    private Integer monthSendDeliveryRule;
    private Integer deliveryTimes;
    @ExcelColumn(name = "制造商编号")
    @ObjectChangeLog(name = "制造商编号")
    private Long manufacturer; //工厂
    private String manufacturerName; //工厂名称
    //sku毛利率
    private BigDecimal grossMargin;
    //基准毛利率（即最低免审毛利率）
    private BigDecimal baseGrossMargin;
    // 标签字段状态
    private String tagFieldStatus;
    // 中文标签状态
    private String chineseTagStatus;
    // sku当前资质审批包含文件数量
    private Integer fileCount;
    // 资质文件路径
    private String docPath;
    // 资质文件路径OSS key值
    private String docPathKey;
    // 资质文件类型
    private String docType;
    // 资质文件备注信息
    private String docMemo;
    //料件号
    // 当前资质文件是否需要后补
    private Integer docIsPostMeeting;
    private Date finishTime;
    private String yjpl;
    private String ejpl;
    private Integer ttlQty;
    // 成本上浮低于 n%
    private String costRiseUnder;
    @ObjectChangeLog(name = "configItems", fieldType = "java.lang.Class")
    private PcsSkuConfigItemsDTO configItems;
    @ObjectChangeLog(name = "attributes", fieldType = "java.lang.Class")
    private PcsSkuAttributesVO attributes;
    private Integer configItemsId;

    private PcsSkuCustomsInfoVO customsInfo;
    private PcsSkuPlanningVO planningInfo;
    //料件号
    private String itemNumber;
    //海关备案号
    private String customsRecordNumber;
    private String declareElement;
    @ExcelColumn(name = "公司属性")
    private String companyAttrName;
    private Integer companyAttr;
    @ExcelColumn(name = "Family")
    @ObjectChangeLog(name = "Family")
    private String family;
    @ExcelColumn(name = "BU")
    private String bu;
    private String newBu;
    @ExcelColumn(name = "商品标签")
    @ObjectChangeLog(name = "商品标签")
    private String productDefination;
    @ExcelColumn(name = "翻单交期")
    @Min(0)
    @ObjectChangeLog(name = "翻单交期")
    private Short turnoverDeliveryPeriod;
    @ExcelColumn(name = "颜色")
    @ObjectChangeLog(name = "颜色")
    private String color;
    @ExcelColumn(name = "长")
    @Min(0)
    @ObjectChangeLog(name = "长")
    private BigDecimal length;
    @ExcelColumn(name = "宽")
    @Min(0)
    @ObjectChangeLog(name = "宽")
    private BigDecimal width;
    @ExcelColumn(name = "高")
    @Min(0)
    @ObjectChangeLog(name = "高")
    private BigDecimal heigth;
    @ExcelColumn(name = "外箱数量")
    @Min(0)
    @ObjectChangeLog(name = "外箱数量")
    private Integer innerboxQuantity;
    @ExcelColumn(name = "Factory 1")
    @ObjectChangeLog(name = "Factory 1")
    private Integer factory1;
    @ExcelColumn(name = "Factory 2")
    @ObjectChangeLog(name = "Factory 2")
    private Integer factory2;
    @ExcelColumn(name = "Factory 3")
    @ObjectChangeLog(name = "Factory 3")
    private Integer factory3;
    //币种
    @ExcelColumn(name = "币种")
    @NotNull
    private String currencyCode;
    private String oldCurrencyCode;
    //外币成本
    @ExcelColumn(name = "成本")
    @Min(value = 0)
    @NotNull
    @ObjectChangeLog(name = "成本")
    private BigDecimal currencyCostPrice;
    //审批中的外币成本
    private BigDecimal newCurrencyCostPrice;
    //供应商税率
    private BigDecimal supplierRate;
    @ExcelColumn(name = "商品类型")
    @NotNull
    private String productTypeDesc;
    // sku税前售价
    private BigDecimal salesPriceBeforeTax;
    // sku （审批中的） 税前售价
    private BigDecimal newSalesPriceBeforeTax;
    // 税前物流费用
    private BigDecimal freightBeforeTax;
    // （审批中的） 税前物流费用
    private BigDecimal newFreightBeforeTax;
    // 税前成本
    private BigDecimal costPriceBeforeTax;
    // （审批中的）税前成本
    private BigDecimal newCostPriceBeforeTax;
    //是否易碎
    @ExcelColumn(name = "易碎")
    private String fragileDesc;
    @ExcelColumn(name = "次级品类编号")
    @ObjectChangeLog(name = "次级品类编号")
    private String secondaryCategoryIdStr;
    @ExcelColumn(name = "采购状态")
    @ObjectChangeLog(name = "采购状态")
    private String canPurcharseStr;
    //有该SKU权限
    private boolean havePermission = true;
    private boolean haveEditPermission;
    //SKU所属部门
    private String departmentCode;
    private Long submitUserId;
    private Boolean whetherQaSpecial;
    private Integer virtualType;
    @ExcelColumn(name = "清关费")
    @ObjectChangeLog(name = "清关费")
    private BigDecimal clearanceFee;
    private BigDecimal newClearanceFee;
    @ExcelColumn(name = "关税")
    @ObjectChangeLog(name = "关税")
    private BigDecimal tariff;
    private BigDecimal newTariff;
    //总成本 = SKU人民币成本+关税+清关费）
    private BigDecimal totalCostPrice;
    //最近一次月末的期末成本
    private BigDecimal latestEndingCost;
    //是否需要审批成本，默认false
    private boolean needApproveCostPrice = false;
    //是否修改成本
    private boolean isModifyCost = false;
    private boolean isModifySalesPrice = false;
    private boolean isModifySuppplier = false;
    private boolean isModifyMaterial = false;
    private boolean isModifySpecification = false;
    private boolean isModifySpecialVariety = false;
    private boolean isModifyBrand = false;
    //成本是否符合变动幅度
    private boolean isModifyCostMeetCondition;

    // 特殊商品种类 -> PcsSkuSpecialVarietyEnum
    private Integer specialVariety;

    @ExcelColumn(name = "特殊商品种类")
    @ObjectChangeLog(name = "特殊商品种类")
    private String specialVarietyName;

    @ExcelColumn(name = "IP合作规则")
    @ObjectChangeLog(name = "IP合作规则")
    private String ipCooperateName;

    //审批中流程节点名称列表
    private List<String> waitProcessNodeNameList;
    private Boolean isAirContraband;
    @ExcelColumn(name = "是否航空违禁品")
    @NotNull
    @ObjectChangeLog(name = "是否航空违禁品")
    private String isAirContrabandName;
    private Short customPrintTemplate;
    @ExcelColumn(name = "定制打印模板")
    @ObjectChangeLog(name = "定制打印模板")
    private String customPrintTemplateDesc;
    private Boolean isIpStyle;
    @ObjectChangeLog(name = "是否ip")
    @ExcelColumn(name = "是否ip")
    private String isIpStyleDesc;
    private Integer collectionId;
    @ObjectChangeLog(name = "collection")
    @ExcelColumn(name = "collection")
    private String collection;
    private Integer subCollectionId;
    @ObjectChangeLog(name = "sub collection")
    @ExcelColumn(name = "sub collection")
    private String subCollection;
    private String series;
    @ObjectChangeLog(name = "品类细分")
    @ExcelColumn(name = "品类细分")
    private String categoryProductType;
    private String submitUserName;
    private Integer skuShelfStatus;
    @ObjectChangeLog(name = "化妆品备案号")
    @ExcelColumn(name = "化妆品备案号")
    private String cosmeticRecordNumber;

    @ObjectChangeLog(name = "产地-省")
    @ExcelColumn(name = "产地-省")
    private String provinceName;
    private Integer cityId;
    @ObjectChangeLog(name = "产地-市")
    @ExcelColumn(name = "产地-市")
    private String cityName;

    @ObjectChangeLog(name = "上市年份")
    @ExcelColumn(name = "上市年份")
    private Integer listingYear;
    @ObjectChangeLog(name = "季节")
    @ExcelColumn(name = "季节")
    private String season;
    @ObjectChangeLog(name = "限量活动")
    @ExcelColumn(name = "限量活动")
    private String limitedActivity;
    private List<PcsSkuSuiteVO> suiteList;

    private Integer ipCooperateId;

    private boolean nonUpdateSku;
    private String maoliDesc;
    //改变来源 1.sku修改 2.配方修改
    private Integer changeSource = 1;
    private String qualificationText;

    public PcsSkuVO() {
    }

    private final static String getISOrNotDesc(Object isOrNot) {
        if (isOrNot == null) {
            return "";
        }
        if (isOrNot instanceof Integer) {
            return (int) isOrNot == 1 ? " 是" : "否";
        }
        if (isOrNot instanceof Short) {
            return (short) isOrNot == 1 ? " 是" : "否";
        }
        if (isOrNot instanceof Boolean) {
            return (boolean) isOrNot == true ? " 是" : "否";
        }
        return "";
    }

    public static long getSerialversionuid() {
        return serialVersionUID;
    }

    public static List<KeyValueVO> getAllServiceLevel() {
        List<KeyValueVO> list = new ArrayList<>();
        KeyValueVO item = new KeyValueVO(PcsSkuConstants.SERVICE_LEVEL_1.toString(), PcsSkuConstants.SERVICE_LEVEL_1.toString());
        list.add(item);
        item = new KeyValueVO(PcsSkuConstants.SERVICE_LEVEL_2.toString(), PcsSkuConstants.SERVICE_LEVEL_2.toString());
        list.add(item);
        item = new KeyValueVO(PcsSkuConstants.SERVICE_LEVEL_3.toString(), PcsSkuConstants.SERVICE_LEVEL_3.toString());
        list.add(item);
        item = new KeyValueVO(PcsSkuConstants.SERVICE_LEVEL_4.toString(), PcsSkuConstants.SERVICE_LEVEL_4.toString());
        list.add(item);
        return list;
    }

    public BigDecimal getTotalCostPrice() {
        return totalCostPrice;
    }

    public void setTotalCostPrice(BigDecimal totalCostPrice) {
        this.totalCostPrice = totalCostPrice;
    }

    public BigDecimal getNewClearanceFee() {
        return newClearanceFee;
    }

    public Integer getChangeSource() {
        return changeSource;
    }

    public void setChangeSource(Integer changeSource) {
        this.changeSource = changeSource;
    }

    public void setNewClearanceFee(BigDecimal newClearanceFee) {
        this.newClearanceFee = newClearanceFee;
    }

    public BigDecimal getNewTariff() {
        return newTariff;
    }

    public void setNewTariff(BigDecimal newTariff) {
        this.newTariff = newTariff;
    }

    public String getBuyerEmail() {
        return buyerEmail;
    }

    public String getMaoliDesc() {
        return maoliDesc;
    }

    public void setMaoliDesc(String maoliDesc) {
        this.maoliDesc = maoliDesc;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public String getCustomsName() {
        return customsName;
    }

    public void setCustomsName(String customsName) {
        this.customsName = customsName;
    }

    public PcsSkuConfigItemsDTO getConfigItems() {
        return configItems;
    }

    public void setConfigItems(PcsSkuConfigItemsDTO configItems) {
        this.configItems = configItems;
    }

    public Integer getConfigItemsId() {
        return configItemsId;
    }

    public void setConfigItemsId(Integer configItemsId) {
        this.configItemsId = configItemsId;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public boolean isAutoDistBarcode() {
        return autoDistBarcode;
    }

    public void setAutoDistBarcode(boolean autoDistBarcode) {
        this.autoDistBarcode = autoDistBarcode;
    }

    public String getYjpl() {
        return yjpl;
    }

    public void setYjpl(String yjpl) {
        this.yjpl = yjpl;
    }

    public String getEjpl() {
        return ejpl;
    }

    public void setEjpl(String ejpl) {
        this.ejpl = ejpl;
    }

    public Integer getTtlQty() {
        return ttlQty;
    }

    public void setTtlQty(Integer ttlQty) {
        this.ttlQty = ttlQty;
    }

    public String getCostRiseUnder() {
        return costRiseUnder;
    }

    public void setCostRiseUnder(String costRiseUnder) {
        this.costRiseUnder = costRiseUnder;
    }

    public String getHasBeenWaiting() {
        String hasBeenWaiting = "";
        if (EmptyUtil.isEmpty(lastSubmitTime)) {
            hasBeenWaiting = "0天0小时";
        } else {
            hasBeenWaiting = DateUtils.workDays(DateUtil.format(lastSubmitTime, "yyyy-MM-dd HH:mm:ss"),
                    DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        return hasBeenWaiting;
    }

    public String getCustomizeType() {
        return customizeType;
    }

    public void setCustomizeType(String customizeType) {
        this.customizeType = customizeType;
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public Long getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(Long manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Integer getDeliveryTimes() {
        return deliveryTimes;
    }

    public void setDeliveryTimes(Integer deliveryTimes) {
        this.deliveryTimes = deliveryTimes;
    }

    public String getIsMonthSendDesc() {
        return isMonthSendDesc;
    }

    public void setIsMonthSendDesc(String isMonthSendDesc) {
        this.isMonthSendDesc = isMonthSendDesc;
    }

    public Integer getIsMonthSend() {
        return isMonthSend;
    }

    public void setIsMonthSend(Integer isMonthSend) {
        this.isMonthSend = isMonthSend;
    }

    public Integer getMonthSendDeliveryRule() {
        return monthSendDeliveryRule;
    }

    public void setMonthSendDeliveryRule(Integer monthSendDeliveryRule) {
        this.monthSendDeliveryRule = monthSendDeliveryRule;
    }

    public Integer getLastApprover() {
        return lastApprover;
    }

    public void setLastApprover(Integer lastApprover) {
        this.lastApprover = lastApprover;
    }

    public String getLastAuditRemark() {
        return lastAuditRemark;
    }

    public void setLastAuditRemark(String lastAuditRemark) {
        this.lastAuditRemark = lastAuditRemark;
    }

    public String getLastApproverName() {
        return lastApproverName;
    }

    public void setLastApproverName(String lastApproverName) {
        this.lastApproverName = lastApproverName;
    }

    public Date getLastAuditTime() {
        return lastAuditTime;
    }

    public void setLastAuditTime(Date lastAuditTime) {
        this.lastAuditTime = lastAuditTime;
    }

    public Date getLastSubmitTime() {
        return lastSubmitTime;
    }

    public void setLastSubmitTime(Date lastSubmitTime) {
        this.lastSubmitTime = lastSubmitTime;
    }

    public String getSecondLegalUnitcode() {
        return secondLegalUnitcode;
    }

    public void setSecondLegalUnitcode(String secondLegalUnitcode) {
        this.secondLegalUnitcode = secondLegalUnitcode;
    }

    public Float getSecondLegalUnitQuantity() {
        return secondLegalUnitQuantity;
    }

    public void setSecondLegalUnitQuantity(Float secondLegalUnitQuantity) {
        this.secondLegalUnitQuantity = secondLegalUnitQuantity;
    }

    public Short getSkuAuditStatus() {
        return skuAuditStatus;
    }

    public void setSkuAuditStatus(Short skuAuditStatus) {
        this.skuAuditStatus = skuAuditStatus;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public String getGoodsHscode() {
        return goodsHscode;
    }

    public void setGoodsHscode(String goodsHscode) {
        this.goodsHscode = goodsHscode;
    }

    public String getGoodsUnitcode() {
        return goodsUnitcode;
    }

    public void setGoodsUnitcode(String goodsUnitcode) {
        this.goodsUnitcode = goodsUnitcode;
    }

    public String getGoodsOriginCountryCode() {
        return goodsOriginCountryCode;
    }

    public void setGoodsOriginCountryCode(String goodsOriginCountryCode) {
        this.goodsOriginCountryCode = goodsOriginCountryCode;
    }

    public BigDecimal getVatRate() {
        return vatRate;
    }

    public void setVatRate(BigDecimal vatRate) {
        this.vatRate = vatRate;
    }

    public BigDecimal getSaleTax() {
        return saleTax;
    }

    public void setSaleTax(BigDecimal saleTax) {
        this.saleTax = saleTax;
    }

    public String getGoodsLegalUnitcode() {
        return goodsLegalUnitcode;
    }

    public void setGoodsLegalUnitcode(String goodsLegalUnitcode) {
        this.goodsLegalUnitcode = goodsLegalUnitcode;
    }

    public Float getGoodsLegalUnitQuantity() {
        return goodsLegalUnitQuantity;
    }

    public void setGoodsLegalUnitQuantity(Float goodsLegalUnitQuantity) {
        this.goodsLegalUnitQuantity = goodsLegalUnitQuantity;
    }

    public Boolean getBatchUpdate() {
        return batchUpdate;
    }

    public void setBatchUpdate(Boolean batchUpdate) {
        this.batchUpdate = batchUpdate;
    }

    public Integer getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Integer clearanceWay) {
        this.clearanceWay = clearanceWay;
    }

    public Boolean getFirstAuditPass() {
        return firstAuditPass;
    }

    public void setFirstAuditPass(Boolean firstAuditPass) {
        this.firstAuditPass = firstAuditPass;
    }

    public Integer getStorageType() {
        return storageType;
    }

    public void setStorageType(Integer storageType) {
        this.storageType = storageType;
    }

    public int getOptType() {
        return optType;
    }

    public void setOptType(int optType) {
        this.optType = optType;
    }

    public BigDecimal getOldCostPrice() {
        return oldCostPrice;
    }

    public void setOldCostPrice(BigDecimal oldCostPrice) {
        this.oldCostPrice = oldCostPrice;
    }

    public String getOldSupplierNameCn() {
        return oldSupplierNameCn;
    }

    public void setOldSupplierNameCn(String oldSupplierNameCn) {
        this.oldSupplierNameCn = oldSupplierNameCn;
    }

    public Long getOldSupplierId() {
        return oldSupplierId;
    }

    public void setOldSupplierId(Long oldSupplierId) {
        this.oldSupplierId = oldSupplierId;
    }

    public BigDecimal getOldSalesPrice() {
        return oldSalesPrice;
    }

    public void setOldSalesPrice(BigDecimal oldSalesPrice) {
        this.oldSalesPrice = oldSalesPrice;
    }

    public String getSupplierProductCode() {
        return supplierProductCode;
    }

    public void setSupplierProductCode(String supplierProductCode) {
        this.supplierProductCode = supplierProductCode;
    }

    public String getWhetherConsignmentName() {
        return whetherConsignmentName != null ? whetherConsignmentName : (whetherConsignment == null ? "" : whetherConsignment == 1 ? "代销" : "经销");
    }

    public void setWhetherConsignmentName(String whetherConsignmentName) {
        this.whetherConsignmentName = whetherConsignmentName;
    }

    public String getIsJitName() {
        return isJitName == null ? (isJit == null ? "否" : (isJit == 1 ? "是" : "否")) : isJitName;
    }

    public void setIsJitName(String isJitName) {
        this.isJitName = isJitName;
    }

    public Integer getDeliveryPeriod() {
        return deliveryPeriod;
    }

    public void setDeliveryPeriod(Integer deliveryPeriod) {
        this.deliveryPeriod = deliveryPeriod;
    }

    public Integer getPreBoxNum() {
        return preBoxNum;
    }

    public void setPreBoxNum(Integer preBoxNum) {
        this.preBoxNum = preBoxNum;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getMyIsJit() {
        return myIsJit;
    }

    public void setMyIsJit(Integer myIsJit) {
        this.myIsJit = myIsJit;
    }

    public Integer getMyCrossBorderFlag() {
        return myCrossBorderFlag;
    }

    public void setMyCrossBorderFlag(Integer myCrossBorderFlag) {
        this.myCrossBorderFlag = myCrossBorderFlag;
    }

    public Integer getMyCanPurchase() {
        return myCanPurchase;
    }

    public void setMyCanPurchase(Integer myCanPurchase) {
        this.myCanPurchase = myCanPurchase;
    }

    public String getSkuTypeName() {
        return skuTypeName == null ? getSkuTypeStr() : skuTypeName;
    }

    public void setSkuTypeName(String skuTypeName) {
        this.skuTypeName = skuTypeName;
    }

    // auto generate

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    // manul mehtods
    public String getCrossBorderName() {
        return crossBorderName;
    }

    public void setCrossBorderName(String crossBorderName) {
        this.crossBorderName = crossBorderName;
    }

    public String getExecutingStandard() {
        return executingStandard;
    }

    public void setExecutingStandard(String executingStandard) {
        this.executingStandard = executingStandard;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    /**
     * 是否定制SKU
     *
     * @return
     */
    public String getCustomMadeStr() {
        return EmptyUtil.isEmpty(skuCustomMadeCode) ? "N" : "Y";
    }

    /**
     * 是否组合SKU
     *
     * @return
     */
    public String getCombinedRecipeStr() {
        return EmptyUtil.isEmpty(combinedSkuRecipeCode) ? "N" : "Y";
    }

    /**
     * 是否可采购
     *
     * @return
     */
    public String getCanPurcharseStr() {
        return canPurcharseStr == null ? PcsSkuPurchaseStatusEnum.getDesc(canPurchase) : canPurcharseStr;
    }

    public void setCanPurcharseStr(String canPurcharseStr) {
        this.canPurcharseStr = canPurcharseStr;
    }

    /**
     * SKU类型
     *
     * @return
     */
    public String getSkuTypeStr() {
        String result = "";
        if (this.skuType != null) {
            // 1原材料2半成品3成品
            if (this.skuType.intValue() == 1) {
                result = "原材料";
            } else if (this.skuType.intValue() == 2) {
                result = "半成品";
            } else if (this.skuType.intValue() == 3) {
                result = "成品";
            }
        }
        return result;
    }

    public void setSkuTypeStr(String skuTypeStr) {
        this.skuTypeStr = skuTypeStr;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public List<Long> getSecondaryCategoryIds() {
        return secondaryCategoryIds;
    }

    public void setSecondaryCategoryIds(List<Long> secondaryCategoryIds) {
        this.secondaryCategoryIds = secondaryCategoryIds;
    }

    public List<PcsSkuCategoryVO> getSecondaryCategoryList() {
        return secondaryCategoryList;
    }

    public void setSecondaryCategoryList(List<PcsSkuCategoryVO> secondaryCategoryList) {
        this.secondaryCategoryList = secondaryCategoryList;
    }

    public Long getDefaultSupplierId() {
        return defaultSupplierId;
    }

    public void setDefaultSupplierId(Long defaultSupplierId) {
        this.defaultSupplierId = defaultSupplierId;
    }

    public String getMerchantCode() {
        return merchantCode;
    }

    public void setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getSkuCustomMadeCode() {
        return skuCustomMadeCode;
    }

    public void setSkuCustomMadeCode(String skuCustomMadeCode) {
        this.skuCustomMadeCode = skuCustomMadeCode;
    }

    public String getCombinedSkuRecipeCode() {
        return combinedSkuRecipeCode;
    }

    public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {
        this.combinedSkuRecipeCode = combinedSkuRecipeCode;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public String getEan13() {
        return ean13;
    }

    public void setEan13(String ean13) {
        this.ean13 = ean13;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getSupplierBarcode() {
        return supplierBarcode;
    }

    public void setSupplierBarcode(String supplierBarcode) {
        this.supplierBarcode = supplierBarcode;
    }

    public Integer getCanPurchase() {
        return canPurchase;
    }

    public void setCanPurchase(Integer canPurchase) {
        this.canPurchase = canPurchase;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public Integer getMoq() {
        return moq;
    }

    public void setMoq(Integer moq) {
        this.moq = moq;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public Integer getIsDeliveriedByStore() {
        return isDeliveriedByStore;
    }

    public void setIsDeliveriedByStore(Integer isDeliveriedByStore) {
        this.isDeliveriedByStore = isDeliveriedByStore;
    }

    public String getDeliveryStores() {
        return deliveryStores;
    }

    public void setDeliveryStores(String deliveryStores) {
        this.deliveryStores = deliveryStores;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Integer getPictureFileId() {
        return pictureFileId;
    }

    public void setPictureFileId(Integer pictureFileId) {
        this.pictureFileId = pictureFileId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPurchaseRemark() {
        return purchaseRemark;
    }

    public void setPurchaseRemark(String purchaseRemark) {
        this.purchaseRemark = purchaseRemark;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public Integer getIsMadeBySelf() {
        return isMadeBySelf;
    }

    public void setIsMadeBySelf(Integer isMadeBySelf) {
        this.isMadeBySelf = isMadeBySelf;
    }

    public Integer getIsImported() {
        return isImported;
    }

    public void setIsImported(Integer isImported) {
        this.isImported = isImported;
    }

    public Integer getIsOwnImported() {
        return isOwnImported;
    }

    public void setIsOwnImported(Integer isOwnImported) {
        this.isOwnImported = isOwnImported;
    }

    public String getIsOwnImportedName() {
        return isOwnImportedName;
    }

    public void setIsOwnImportedName(String isOwnImportedName) {
        this.isOwnImportedName = isOwnImportedName;
    }

    public Integer getQualifyAuditStatus() {
        return qualifyAuditStatus;
    }

    public void setQualifyAuditStatus(Integer qualifyAuditStatus) {
        this.qualifyAuditStatus = qualifyAuditStatus;
    }

    public Integer getQualifyFlowTrend() {
        return qualifyFlowTrend;
    }

    public void setQualifyFlowTrend(Integer qualifyFlowTrend) {
        this.qualifyFlowTrend = qualifyFlowTrend;
    }

    public Integer getIsPostMeeting() {
        return isPostMeeting;
    }

    public void setIsPostMeeting(Integer isPostMeeting) {
        this.isPostMeeting = isPostMeeting;
    }

    public Long getQualifyId() {
        return qualifyId;
    }

    public void setQualifyId(Long qualifyId) {
        this.qualifyId = qualifyId;
    }

    public Integer getAuditDecision() {
        return auditDecision;
    }

    public void setAuditDecision(Integer auditDecision) {
        this.auditDecision = auditDecision;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierNameCn() {
        return supplierNameCn;
    }

    public void setSupplierNameCn(String supplierNameCn) {
        this.supplierNameCn = supplierNameCn;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getSkucategoryFullName() {
        return skucategoryFullName;
    }

    public void setSkucategoryFullName(String skucategoryFullName) {
        this.skucategoryFullName = skucategoryFullName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getBrandNameCn() {
        return brandNameCn;
    }

    public void setBrandNameCn(String brandNameCn) {
        this.brandNameCn = brandNameCn;
    }

    public Long getBrandCountryId() {
        return brandCountryId;
    }

    public void setBrandCountryId(Long brandCountryId) {
        this.brandCountryId = brandCountryId;
    }

    public String getBrandCountryName() {
        return brandCountryName;
    }

    public void setBrandCountryName(String brandCountryName) {
        this.brandCountryName = brandCountryName;
    }

    public String getPictureFileName() {
        return pictureFileName;
    }

    public void setPictureFileName(String pictureFileName) {
        this.pictureFileName = pictureFileName;
    }

    public Integer getPointDeductRule() {
        return pointDeductRule;
    }

    public void setPointDeductRule(Integer pointDeductRule) {
        this.pointDeductRule = pointDeductRule;
    }

    public BigDecimal getPointDeductPoint() {
        return pointDeductPoint;
    }

    public void setPointDeductPoint(BigDecimal pointDeductPoint) {
        this.pointDeductPoint = pointDeductPoint;
    }

    public BigDecimal getPointDuductPrice() {
        return pointDuductPrice;
    }

    public void setPointDuductPrice(BigDecimal pointDuductPrice) {
        this.pointDuductPrice = pointDuductPrice;
    }

    public String getSkuCategoryName() {
        return skuCategoryName;
    }

    public void setSkuCategoryName(String skuCategoryName) {
        this.skuCategoryName = skuCategoryName;
    }

    public Integer getCanRemark() {
        return canRemark;
    }

    public void setCanRemark(Integer canRemark) {
        this.canRemark = canRemark;
    }

    public Integer getCanCustomizeSalesPrice() {
        return canCustomizeSalesPrice;
    }

    public void setCanCustomizeSalesPrice(Integer canCustomizeSalesPrice) {
        this.canCustomizeSalesPrice = canCustomizeSalesPrice;
    }

    public Integer getServiceLevel() {
        return serviceLevel;
    }

    public void setServiceLevel(Integer serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public Date getSaleEndDate() {
        return saleEndDate;
    }

    public void setSaleEndDate(Date saleEndDate) {
        this.saleEndDate = saleEndDate;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public List<PcsWatermarkVO> getWatermarkList() {
        return watermarkList;
    }

    public void setWatermarkList(List<PcsWatermarkVO> watermarkList) {
        this.watermarkList = watermarkList;
    }

    public String getWatermarkCodesJson() {
        return watermarkCodesJson;
    }

    public void setWatermarkCodesJson(String watermarkCodesJson) {
        this.watermarkCodesJson = watermarkCodesJson;
    }

    public List<PcsTagVO> getTagList() {
        return tagList;
    }

    public void setTagList(List<PcsTagVO> tagList) {
        this.tagList = tagList;
    }

    public String getTagCodesJson() {
        return tagCodesJson;
    }

    public void setTagCodesJson(String tagCodesJson) {
        this.tagCodesJson = tagCodesJson;
    }

    public String getIsMadeBySelfName() {
        return isMadeBySelfName == null ? getISOrNotDesc(isMadeBySelf) : isMadeBySelfName;
    }

    public void setIsMadeBySelfName(String isMadeBySelfName) {
        this.isMadeBySelfName = isMadeBySelfName;
    }

    public String getIsImportedName() {
        return isImportedName == null ? (isImported == null ? "" : (isImported == 1 ? "是" : "否")) : isImportedName;
    }

    public void setIsImportedName(String isImportedName) {
        this.isImportedName = isImportedName;
    }

    public String getBuyerName() {
        if (this.buyerId == null) {
            return null;
        }
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getBuyRealName() {
        return buyRealName;
    }

    public void setBuyRealName(String buyRealName) {
        this.buyRealName = buyRealName;
    }

    public Integer getVirtualType() {
        return virtualType;
    }

    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getSuggestPackage() {
        return suggestPackage;
    }

    public void setSuggestPackage(String suggestPackage) {
        this.suggestPackage = suggestPackage;
    }

    public Integer getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(Integer shelfLife) {
        this.shelfLife = shelfLife;
    }

    public Integer getIsHasTag() {
        return isHasTag;
    }

    public void setIsHasTag(Integer isHasTag) {
        this.isHasTag = isHasTag;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getIsSubmit() {
        return isSubmit;
    }

    public void setIsSubmit(Integer isSubmit) {
        this.isSubmit = isSubmit;
    }

    public Integer getCerIsSubmit() {
        return cerIsSubmit;
    }

    public void setCerIsSubmit(Integer cerIsSubmit) {
        this.cerIsSubmit = cerIsSubmit;
    }

    public Integer getCerCheckStatus() {
        return cerCheckStatus;
    }

    public void setCerCheckStatus(Integer cerCheckStatus) {
        this.cerCheckStatus = cerCheckStatus;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getLevel1CategoryName() {
        return level1CategoryName;
    }

    public void setLevel1CategoryName(String level1CategoryName) {
        this.level1CategoryName = level1CategoryName;
    }

    public String getLevel1SkucategoryFullName() {
        return level1SkucategoryFullName;
    }

    public void setLevel1SkucategoryFullName(String level1SkucategoryFullName) {
        this.level1SkucategoryFullName = level1SkucategoryFullName;
    }

    public List<PcsSkuCategoryVO> getFrontCategoryList() {
        return frontCategoryList;
    }

    public void setFrontCategoryList(List<PcsSkuCategoryVO> frontCategoryList) {
        this.frontCategoryList = frontCategoryList;
    }

    public List<PcsSkuCategoryVO> getBackCategoryList() {
        return backCategoryList;
    }

    public void setBackCategoryList(List<PcsSkuCategoryVO> backCategoryList) {
        this.backCategoryList = backCategoryList;
    }

    public String getClearanceWayCN() {
        return clearanceWayCN;
    }

    public void setClearanceWayCN(String clearanceWayCN) {
        this.clearanceWayCN = clearanceWayCN;
    }

    public Integer getTagId() {
        return tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    public Date getTagLastUpdateTime() {
        return tagLastUpdateTime;
    }

    public void setTagLastUpdateTime(Date tagLastUpdateTime) {
        this.tagLastUpdateTime = tagLastUpdateTime;
    }

    public Integer getWhetherConsignment() {
        return whetherConsignment;
    }

    public void setWhetherConsignment(Integer whetherConsignment) {
        this.whetherConsignment = whetherConsignment;
    }

    public Integer getWhetherVipDisdount() {
        return whetherVipDisdount;
    }

    public void setWhetherVipDisdount(Integer whetherVipDisdount) {
        this.whetherVipDisdount = whetherVipDisdount;
    }

    public Integer getCertificateSize() {
        return certificateSize;
    }

    public void setCertificateSize(Integer certificateSize) {
        this.certificateSize = certificateSize;
    }

    public List<PcsSkuBarcodeVO> getBarcodeList() {
        return barcodeList;
    }

    public void setBarcodeList(List<PcsSkuBarcodeVO> barcodeList) {
        this.barcodeList = barcodeList;
    }

    public String getTagFieldStatus() {
        return tagFieldStatus;
    }

    public void setTagFieldStatus(String tagFieldStatus) {
        this.tagFieldStatus = tagFieldStatus;
    }

    public String getChineseTagStatus() {
        return chineseTagStatus;
    }

    public void setChineseTagStatus(String chineseTagStatus) {
        this.chineseTagStatus = chineseTagStatus;
    }

    public Integer getFileCount() {
        return fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    public String getDocPath() {
        return docPath;
    }

    public void setDocPath(String docPath) {
        this.docPath = docPath;
    }

    public String getDocPathKey() {
        return docPathKey;
    }

    public void setDocPathKey(String docPathKey) {
        this.docPathKey = docPathKey;
    }

    public String getDocType() {
        return docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getDocMemo() {
        return docMemo;
    }

    public void setDocMemo(String docMemo) {
        this.docMemo = docMemo;
    }

    public Integer getDocIsPostMeeting() {
        return docIsPostMeeting;
    }

    public void setDocIsPostMeeting(Integer docIsPostMeeting) {
        this.docIsPostMeeting = docIsPostMeeting;
    }

    public Integer getCanCustomize() {
        return canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }

    public List<Integer> getCustomizeTypeList() {
        if (customizeType != null) {
            String[] customizeTypeArr = customizeType.split(",");
            customizeTypeList = new ArrayList<>();
            for (String customizeType : customizeTypeArr) {
                if (!customizeType.trim().equals("")) {
                    customizeTypeList.add(Integer.valueOf(customizeType));
                }
            }
        } else {
            return new ArrayList<>();
        }
        return customizeTypeList;
    }

    public void setCustomizeTypeList(List<Integer> customizeTypeList) {
        this.customizeTypeList = customizeTypeList;
    }

    public BigDecimal getCustomizationPrice() {
        return customizationPrice;
    }

    public void setCustomizationPrice(BigDecimal customizationPrice) {
        this.customizationPrice = customizationPrice;
    }

    public PcsCustomizeVO getCustomizeVO() {
        return customizeVO;
    }

    public void setCustomizeVO(PcsCustomizeVO customizeVO) {
        this.customizeVO = customizeVO;
    }

    public BigDecimal getGrossMargin() {
        return grossMargin;
    }

    public void setGrossMargin(BigDecimal grossMargin) {
        this.grossMargin = grossMargin;
    }

    public BigDecimal getBaseGrossMargin() {
        return baseGrossMargin;
    }

    public void setBaseGrossMargin(BigDecimal baseGrossMargin) {
        this.baseGrossMargin = baseGrossMargin;
    }

    public String getWhetherLogistics() {
        return whetherLogistics;
    }

    public void setWhetherLogistics(String whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    public String getWhetherVirtual() {
        return whetherVirtual;
    }

    public void setWhetherVirtual(String whetherVirtual) {
        this.whetherVirtual = whetherVirtual;
    }

    public BigDecimal getAverageLogisticsCosts() {
        return averageLogisticsCosts;
    }

    public void setAverageLogisticsCosts(BigDecimal averageLogisticsCosts) {
        this.averageLogisticsCosts = averageLogisticsCosts;
    }

    public BigDecimal getNewAverageLogisticsCosts() {
        return newAverageLogisticsCosts;
    }

    public void setNewAverageLogisticsCosts(BigDecimal newAverageLogisticsCosts) {
        this.newAverageLogisticsCosts = newAverageLogisticsCosts;
    }

    public String getInstallService() {
        return installService;
    }

    public void setInstallService(String installService) {
        this.installService = installService;
    }

    public String getSkuStatusDesc() {
        if (EmptyUtil.isEmpty(skuStatus)) {
            return "未知状态";
        }
        return PcsSkuStatusEnum.getDesc(skuStatus);
    }

    public void setSkuStatusDesc(String skuStatusDesc) {
        this.skuStatusDesc = skuStatusDesc;
    }

    public String getItemNumber() {
        return itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public String getCustomsRecordNumber() {
        return customsRecordNumber;
    }

    public void setCustomsRecordNumber(String customsRecordNumber) {
        this.customsRecordNumber = customsRecordNumber;
    }

    public String getDeclareElement() {
        return declareElement;
    }

    public void setDeclareElement(String declareElement) {
        this.declareElement = declareElement;
    }

    public String getCompanyAttrName() {
        return companyAttrName;
    }

    public void setCompanyAttrName(String companyAttrName) {
        this.companyAttrName = companyAttrName;
    }

    public Integer getCompanyAttr() {
        return companyAttr;
    }

    public void setCompanyAttr(Integer companyAttr) {
        this.companyAttr = companyAttr;
    }

    public PcsSkuCustomsInfoVO getCustomsInfo() {
        return customsInfo;
    }

    public void setCustomsInfo(PcsSkuCustomsInfoVO customsInfo) {
        this.customsInfo = customsInfo;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public Integer getDefaultWarehouse() {
        return defaultWarehouse;
    }

    public void setDefaultWarehouse(Integer defaultWarehouse) {
        this.defaultWarehouse = defaultWarehouse;
    }

    public Boolean getFragile() {
        return fragile;
    }

    public void setFragile(Boolean fragile) {
        this.fragile = fragile;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public PcsSkuPlanningVO getPlanningInfo() {
        return planningInfo;
    }

    public void setPlanningInfo(PcsSkuPlanningVO planningInfo) {
        this.planningInfo = planningInfo;
    }

    public String getFamily() {
        return family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public String getProductDefination() {
        return productDefination;
    }

    public void setProductDefination(String productDefination) {
        this.productDefination = productDefination;
    }

    public Short getTurnoverDeliveryPeriod() {
        return turnoverDeliveryPeriod;
    }

    public void setTurnoverDeliveryPeriod(Short turnoverDeliveryPeriod) {
        this.turnoverDeliveryPeriod = turnoverDeliveryPeriod;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeigth() {
        return heigth;
    }

    public void setHeigth(BigDecimal heigth) {
        this.heigth = heigth;
    }

    public Integer getInnerboxQuantity() {
        return innerboxQuantity;
    }

    public void setInnerboxQuantity(Integer innerboxQuantity) {
        this.innerboxQuantity = innerboxQuantity;
    }

    public Integer getFactory1() {
        return factory1;
    }

    public void setFactory1(Integer factory1) {
        this.factory1 = factory1;
    }

    public Integer getFactory2() {
        return factory2;
    }

    public void setFactory2(Integer factory2) {
        this.factory2 = factory2;
    }

    public Integer getFactory3() {
        return factory3;
    }

    public void setFactory3(Integer factory3) {
        this.factory3 = factory3;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getCurrencyCostPrice() {
        return currencyCostPrice;
    }

    public void setCurrencyCostPrice(BigDecimal currencyCostPrice) {
        this.currencyCostPrice = currencyCostPrice;
    }

    public String getOldCurrencyCode() {
        return oldCurrencyCode;
    }

    public void setOldCurrencyCode(String oldCurrencyCode) {
        this.oldCurrencyCode = oldCurrencyCode;
    }

    public BigDecimal getNewCurrencyCostPrice() {
        return newCurrencyCostPrice;
    }

    public void setNewCurrencyCostPrice(BigDecimal newCurrencyCostPrice) {
        this.newCurrencyCostPrice = newCurrencyCostPrice;
    }

    public BigDecimal getSupplierRate() {
        return supplierRate;
    }

    public void setSupplierRate(BigDecimal supplierRate) {
        this.supplierRate = supplierRate;
    }

    public Short getOptSource() {
        return optSource;
    }

    public void setOptSource(Short optSource) {
        this.optSource = optSource;
    }

    public String getProductTypeDesc() {
        if (EmptyUtil.isNotEmpty(this.productTypeDesc)) {
            return  this.productTypeDesc.trim();
        }
        return this.productType == null ? "":PcsSkuProductTypeEnum.getDesc(this.productType.shortValue());
    }

    public void setProductTypeDesc(String productTypeDesc) {
        this.productTypeDesc = productTypeDesc;
    }

    public String getFragileDesc() {
        return fragileDesc;
    }

    public void setFragileDesc(String fragileDesc) {
        this.fragileDesc = fragileDesc;
    }

    public BigDecimal getSalesPriceBeforeTax() {
        return salesPriceBeforeTax;
    }

    public void setSalesPriceBeforeTax(BigDecimal salesPriceBeforeTax) {
        this.salesPriceBeforeTax = salesPriceBeforeTax;
    }

    public BigDecimal getFreightBeforeTax() {
        return freightBeforeTax;
    }

    public void setFreightBeforeTax(BigDecimal freightBeforeTax) {
        this.freightBeforeTax = freightBeforeTax;
    }

    public BigDecimal getCostPriceBeforeTax() {
        return costPriceBeforeTax;
    }

    public void setCostPriceBeforeTax(BigDecimal costPriceBeforeTax) {
        this.costPriceBeforeTax = costPriceBeforeTax;
    }

    public BigDecimal getNewSalesPriceBeforeTax() {
        return newSalesPriceBeforeTax;
    }

    public void setNewSalesPriceBeforeTax(BigDecimal newSalesPriceBeforeTax) {
        this.newSalesPriceBeforeTax = newSalesPriceBeforeTax;
    }

    public BigDecimal getNewFreightBeforeTax() {
        return newFreightBeforeTax;
    }

    public void setNewFreightBeforeTax(BigDecimal newFreightBeforeTax) {
        this.newFreightBeforeTax = newFreightBeforeTax;
    }

    public BigDecimal getNewCostPriceBeforeTax() {
        return newCostPriceBeforeTax;
    }

    public void setNewCostPriceBeforeTax(BigDecimal newCostPriceBeforeTax) {
        this.newCostPriceBeforeTax = newCostPriceBeforeTax;
    }

    public BigDecimal getClearanceFee() {
        return clearanceFee;
    }

    public void setClearanceFee(BigDecimal clearanceFee) {
        this.clearanceFee = clearanceFee;
    }

    public BigDecimal getTariff() {
        return tariff;
    }

    public void setTariff(BigDecimal tariff) {
        this.tariff = tariff;
    }

    public String getSecondaryCategoryIdStr() {
        if (secondaryCategoryIdStr != null) {
            return secondaryCategoryIdStr;
        }

        if (secondaryCategoryList == null || secondaryCategoryList.size() == 0) {
            return secondaryCategoryIdStr;
        }
        secondaryCategoryIdStr = "";
        for (int i = 0; i < secondaryCategoryList.size(); i++) {
            if (i == 0) {
                secondaryCategoryIdStr += secondaryCategoryList.get(i).getId();
            } else {
                secondaryCategoryIdStr += "," + secondaryCategoryList.get(i).getId();
            }
        }
        return secondaryCategoryIdStr;
    }

    public void setSecondaryCategoryIdStr(String secondaryCategoryIdStr) {
        this.secondaryCategoryIdStr = secondaryCategoryIdStr;
    }

    public boolean isHavePermission() {
        return havePermission;
    }

    public void setHavePermission(boolean havePermission) {
        this.havePermission = havePermission;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public boolean isHaveEditPermission() {
        return haveEditPermission;
    }

    public void setHaveEditPermission(boolean haveEditPermission) {
        this.haveEditPermission = haveEditPermission;
    }

    public Long getSubmitUserId() {
        return submitUserId;
    }

    public void setSubmitUserId(Long submitUserId) {
        this.submitUserId = submitUserId;
    }

    public Boolean getWhetherQaSpecial() {
        return whetherQaSpecial;
    }

    public void setWhetherQaSpecial(Boolean whetherQaSpecial) {
        this.whetherQaSpecial = whetherQaSpecial;
    }

    public BigDecimal getLatestEndingCost() {
        return latestEndingCost;
    }

    public void setLatestEndingCost(BigDecimal latestEndingCost) {
        this.latestEndingCost = latestEndingCost;
    }

    public boolean isNeedApproveCostPrice() {
        return needApproveCostPrice;
    }

    public void setNeedApproveCostPrice(boolean needApproveCostPrice) {
        this.needApproveCostPrice = needApproveCostPrice;
    }

    public String getSubmitUserName() {
        return submitUserName;
    }

    public void setSubmitUserName(String submitUserName) {
        this.submitUserName = submitUserName;
    }

    public Integer getSpecialVariety() {
        return specialVariety;
    }

    public void setSpecialVariety(Integer specialVariety) {
        this.specialVariety = specialVariety;
    }

    public String getSpecialVarietyName() {
        return specialVarietyName;
    }

    public void setSpecialVarietyName(String specialVarietyName) {
        this.specialVarietyName = specialVarietyName;
    }

    public Boolean getIsAirContraband() {
        return isAirContraband;
    }

    public void setIsAirContraband(Boolean isAirContraband) {
        this.isAirContraband = isAirContraband;
    }

    public String getIsAirContrabandName() {
        return isAirContrabandName;
    }

    public void setIsAirContrabandName(String isAirContrabandName) {
        this.isAirContrabandName = isAirContrabandName;
    }

    public List<String> getWaitProcessNodeNameList() {
        return waitProcessNodeNameList;
    }

    public void setWaitProcessNodeNameList(List<String> waitProcessNodeNameList) {
        this.waitProcessNodeNameList = waitProcessNodeNameList;
    }

    public Long getNewCategoryId() {
        return newCategoryId;
    }

    public void setNewCategoryId(Long newCategoryId) {
        this.newCategoryId = newCategoryId;
    }

    public String getNewBu() {
        return newBu;
    }

    public void setNewBu(String newBu) {
        this.newBu = newBu;
    }

    public String getNewCategoryFullName() {
        return newCategoryFullName;
    }

    public void setNewCategoryFullName(String newCategoryFullName) {
        this.newCategoryFullName = newCategoryFullName;
    }

    public String getNewCategoryName() {
        return newCategoryName;
    }

    public void setNewCategoryName(String newCategoryName) {
        this.newCategoryName = newCategoryName;
    }

    public Short getCustomPrintTemplate() {
        return customPrintTemplate;
    }

    public void setCustomPrintTemplate(Short customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }

    public String getCustomPrintTemplateDesc() {
        return customPrintTemplateDesc;
    }

    public void setCustomPrintTemplateDesc(String customPrintTemplateDesc) {
        this.customPrintTemplateDesc = customPrintTemplateDesc;
    }

    public Boolean getIpStyle() {
        return isIpStyle;
    }

    public void setIpStyle(Boolean ipStyle) {
        isIpStyle = ipStyle;
    }

    public String getIsIpStyleDesc() {
        return isIpStyleDesc;
    }

    public void setIsIpStyleDesc(String isIpStyleDesc) {
        this.isIpStyleDesc = isIpStyleDesc;
    }

    public Integer getCollectionId() {
        return collectionId;
    }

    public void setCollectionId(Integer collectionId) {
        this.collectionId = collectionId;
    }

    public String getCollection() {
        return collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    // self
    // skuStatus

    public Integer getSubCollectionId() {
        return subCollectionId;
    }

    public void setSubCollectionId(Integer subCollectionId) {
        this.subCollectionId = subCollectionId;
    }

    public String getSubCollection() {
        return subCollection;
    }

    public void setSubCollection(String subCollection) {
        this.subCollection = subCollection;
    }

    public String getSeries() {
        return series;
    }
    // serviceLevel

    public void setSeries(String series) {
        this.series = series;
    }

    public String getCategoryProductType() {
        return categoryProductType;
    }

    public void setCategoryProductType(String categoryProductType) {
        this.categoryProductType = categoryProductType;
    }

    public boolean getIsModifyCost() {
        return isModifyCost;
    }

    public void setIsModifyCost(boolean modifyCost) {
        isModifyCost = modifyCost;
    }

    public Integer getSkuShelfStatus() {
        return skuShelfStatus;
    }

    public void setSkuShelfStatus(Integer skuShelfStatus) {
        this.skuShelfStatus = skuShelfStatus;
    }

    public String getSkuShelfStatusDesc() {
        return YesOrNoEnum.YES.getCode().equals(skuShelfStatus) ? "上架" : "下架";
    }

    public List<PcsSkuSuiteVO> getSuiteList() {
     return suiteList;
    }

    public void setSuiteList(List<PcsSkuSuiteVO> suiteList) {
     this.suiteList = suiteList;
    }

    public String getCosmeticRecordNumber() {
        return cosmeticRecordNumber;
    }

    public void setCosmeticRecordNumber(String cosmeticRecordNumber) {
        this.cosmeticRecordNumber = cosmeticRecordNumber;
    }

    public boolean getIsModifySalesPrice() {
        return isModifySalesPrice;
    }

    public void setIsModifySalesPrice(boolean modifySalesPrice) {
        isModifySalesPrice = modifySalesPrice;
    }

    public boolean getIsModifySuppplier() {
        return isModifySuppplier;
    }

    public void setIsModifySuppplier(boolean modifySuppplier) {
        isModifySuppplier = modifySuppplier;
    }

    public boolean isModifyCostMeetCondition() {
        return isModifyCostMeetCondition;
    }

    public void setModifyCostMeetCondition(boolean costModifyMeetCondition) {
        isModifyCostMeetCondition = costModifyMeetCondition;
    }

    public Integer getIpCooperateId() {
        return ipCooperateId;
    }

    public void setIpCooperateId(Integer ipCooperateId) {
        this.ipCooperateId = ipCooperateId;
    }

    public boolean isNonUpdateSku() {
        return nonUpdateSku;
    }

    public void setNonUpdateSku(boolean nonUpdateSku) {
        this.nonUpdateSku = nonUpdateSku;
    }

    public String getIpCooperateName() {
        return ipCooperateName;
    }

    public void setIpCooperateName(String ipCooperateName) {
        this.ipCooperateName = ipCooperateName;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public Integer getCityId() {
        return cityId;
    }

    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getListingYear() {
        return listingYear;
    }

    public void setListingYear(Integer listingYear) {
        this.listingYear = listingYear;
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getLimitedActivity() {
        return limitedActivity;
    }

    public void setLimitedActivity(String limitedActivity) {
        this.limitedActivity = limitedActivity;
    }

    public boolean getIsModifyMaterial() {
        return isModifyMaterial;
    }

    public void setIsModifyMaterial(boolean modifyMaterial) {
        isModifyMaterial = modifyMaterial;
    }

    public boolean getIsModifySpecification() {
        return isModifySpecification;
    }

    public void setIsModifySpecification(boolean modifySpecification) {
        isModifySpecification = modifySpecification;
    }

    public boolean getIsModifySpecialVariety() {
        return isModifySpecialVariety;
    }

    public void setIsModifySpecialVariety(boolean modifySpecialVariety) {
        isModifySpecialVariety = modifySpecialVariety;
    }

    public boolean getIsModifyBrand() {
        return isModifyBrand;
    }

    public void setIsModifyBrand(boolean modifyBrand) {
        isModifyBrand = modifyBrand;
    }

    public String getQualificationText() {
        return qualificationText;
    }

    public void setQualificationText(String qualificationText) {
        this.qualificationText = qualificationText;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public PcsSkuAttributesVO getAttributes() {
        return attributes;
    }

    public void setAttributes(PcsSkuAttributesVO attributes) {
        this.attributes = attributes;
    }

    public String getProcessDescription() {
        return processDescription;
    }

    public void setProcessDescription(String processDescription) {
        this.processDescription = processDescription;
    }

    public Integer getUnbindDistBarcode() {
        return unbindDistBarcode;
    }

    public void setUnbindDistBarcode(Integer unbindDistBarcode) {
        this.unbindDistBarcode = unbindDistBarcode;
    }
}