package com.thebeastshop.pegasus.merchandise.enums;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2019/8/14 11:49
 * 人工推荐选购页
 */
public enum ProdPositionEnum {

    ADD_ON_ITEM("免邮凑单推荐"),
    PROD_DETAIL("商品详细推荐"),
    CART("购物车");

    public String cn;
    private ProdPositionEnum(String cn){
        this.cn = cn;
    }

    public static Map<String, String> getMap(){
        Map<String, String> map = new LinkedHashMap<>();
        for (ProdPositionEnum position : ProdPositionEnum.values()) {
            map.put(position.name(), position.cn);
        }
        return map;
    }


}
