package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * 价格折扣提报状态
 * @author Gary
 *
 */
public enum PcsSkuDiscountActivityApplyStatusEnum {

	REJECT(2, "驳回"),
	UNSUBIMITTED(0, "草稿"),
	UNDER_REVIEW(1, "待审批"),
	COMPLETED_REVIEW_PART(8, "审批完成（有异常）"),
	COMPLETED_REVIEW(9, "审核完成"),
	;

	public final Integer status;
	public final String desc;

	public static final List<PcsSkuDiscountActivityApplyStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuDiscountActivityApplyStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}


	public final static List<Integer> statusListInTheReview() {
	  List<Integer> list = new ArrayList<>();
	  list.add(UNDER_REVIEW.getStatus());
      //list.add(CUSTOMS_REVIEW.status);
	  //list.add(FINANCE_REVIEW.status);
	  return list;
	}

	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
		for (PcsSkuDiscountActivityApplyStatusEnum skuStatusEnum : PcsSkuDiscountActivityApplyStatusEnum.values()) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", skuStatusEnum.status);
			map.put("name", skuStatusEnum.desc);
			listMap.add(map);
		}
		return listMap;
	}

	 // 普通方法
    public static String getDesc(int status) {
			for (PcsSkuDiscountActivityApplyStatusEnum c : ALL) {
					if (c.getStatus() == status) {
							return c.desc;
					}
			}
			return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
