package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.RecommendSceneTypeEnum;

import java.math.BigDecimal;
import java.util.List;

/**
 * 推荐调用接口传参VO 
 * @author donghui
 */
public class RecommendParamVO extends AbstractDomain {
	private Type type;//推荐类型
	private Integer limitSize;//记录数
	private String chnCode; //渠道
	private Integer memberLevel;
	private Integer accessWay;
	private BigDecimal discount;//会员折扣
	private BigDecimal bdDiscount;//生日折扣
	private String productCode;//为商品详细推荐时,需要商品code


	private List<String> productCodeList;


	private String memberCode;
	private String imei;//设备号
	private String ip;
	private RecommendSceneTypeEnum recommendSceneTypeEnum;

	public RecommendParamVO(){}
	
	
	/** 推荐类型 */
	public enum Type{
		SHOPPING_CART,// 购物车推荐
		ADD_ON_ITEM,// 免邮凑单推荐
		PROD_DETAIL;//商品详细推荐"
	}


	public Type getType() {
		return type;
	}


	public void setType(Type type) {
		this.type = type;
	}


	public Integer getLimitSize() {
		return limitSize;
	}


	public void setLimitSize(Integer limitSize) {
		this.limitSize = limitSize;
	}


	public String getChnCode() {
		return chnCode;
	}


	public void setChnCode(String chnCode) {
		this.chnCode = chnCode;
	}


	public Integer getMemberLevel() {
		return memberLevel;
	}


	public void setMemberLevel(Integer memberLevel) {
		this.memberLevel = memberLevel;
	}


	public Integer getAccessWay() {
		return accessWay;
	}


	public void setAccessWay(Integer accessWay) {
		this.accessWay = accessWay;
	}


	public BigDecimal getDiscount() {
		return discount;
	}


	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}


	public String getProductCode() {
		return productCode;
	}


	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public List<String> getProductCodeList() {
		return productCodeList;
	}

	public void setProductCodeList(List<String> productCodeList) {
		this.productCodeList = productCodeList;
	}


	public BigDecimal getBdDiscount() {
		return bdDiscount;
	}

	public void setBdDiscount(BigDecimal bdDiscount) {
		this.bdDiscount = bdDiscount;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getImei() {
		return imei;
	}

	public void setImei(String imei) {
		this.imei = imei;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public RecommendSceneTypeEnum getRecommendSceneTypeEnum() {
		return recommendSceneTypeEnum;
	}

	public void setRecommendSceneTypeEnum(RecommendSceneTypeEnum recommendSceneTypeEnum) {
		this.recommendSceneTypeEnum = recommendSceneTypeEnum;
	}
}