package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;

public interface McPcsImportDocService {


	/**
     * 创建SKU进口单证
     * @param vo
     * @return
     */
    Long create(PcsImportDocVO vo);
    
    /**
     * 批量创建SKU进口单证
     * @param vo
     * @return
     */
    List<Long> createPcsImportDocs(List<PcsImportDocVO> list);
    
	boolean createPcsImportDocs(List<PcsImportDocVO> importDocVOs, Long id);

    /**
     * 删除SKU进口单证
     * @param vo
     * @return
     */
    int deleteById(Long id);
    
    /**
     * 删除SKU进口单证
     * @param vo
     * @return
     */
    Long deleteByQualifyId(Long qualifyId);
    
    /**
     * 更新SKU进口单证
     * @param vo
     * @return
     */
    Boolean update(PcsImportDocVO vo);

    /**
     * 根据ID查找SKU进口单证
     * @param id
     * @return
     */
    PcsImportDocVO findById(Long id);
    
    /**
     * 根据qualifyId查找SKU进口单证
     * @param id
     * @return
     */
    List<PcsImportDocVO> findByQualifyId(Long qualifyId);

    /**
     * 根据相应条件查找SKU进口单证
     * @param cond
     * @return
     */
    List<PcsImportDocVO> findByCond(PcsImportDocCond cond);

    /**
     * 根据条件查找SKU进口单证
     * @param cond
     * @return
     */
    List<PcsImportDocVO> findByCriteria(PcsImportDocCond cond);

    /**
     * 根据id集合查找SKU进口单证
     * @param ids
     * @return
     */
    List<PcsImportDocVO> findByIds(List<Long> ids);

    long countByCond(PcsImportDocCond cond);

}
