package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.hotlink.annotation.Hotlink;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsCampaignSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.vo.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */

public interface McPsProductService {

    boolean create(PsProductVO vo);
    boolean create(List<PsProductVO> vos);
    boolean update(PsProductVO vo);
    boolean update(List<PsProductVO> vos);

    boolean createOrUpdate(PsProductVO vo);

    boolean createOrUpdate(List<PsProductVO> vos);

    /**
     *
     * @param id es's id, eg.SkuCode,ProdId
     * @return
     */
    boolean deleteById(String id);

    /**
     *
     * @param ids  es's id, eg.SkuCode,ProdId
     * @return
     */
    boolean deleteByIds(List<String> ids);
    List<PsProductVO> findAll();

    List<PsProductVO> findByProdName(String name);
    List<PsProductVO> findByProdCode(String code);
    PsProductVO findByProdId(Long prodId);

//    @Hotlink
//    List<PsProductVO> findGiftsByCond(PsProductCond cond);


    List<PsProductVO> findByCond(PsProductCond cond);

    List<PsProductVO> findByCond(PsProductCond cond,List<String> returnFields, List<String> excludeFields);
    List<PsProductVO> findByCondToCampaign(PsProductCond cond);

//    @Hotlink
//    List<PsProductVO> findByCondNoFilter(PsProductCond cond);
    //通过主商品code查询搭配组合商品
    List<PsProductVO> findCollocationCombinedProdByCode(PsProductCond cond);

//    /**
//     * replace by findByCond(PsProductCond cond)
//     * @param cond
//     * @param matchGlobalCampaigns
//     * @return
//     */

//    @Hotlink
//    List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns);

    Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond);

    /**
     * 获取全场非SKU维度活动
     * @return
     */
    List<EsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond);

    List<PsProductVO> findByFields(Map<String, Object> params);

    boolean updateBySkuCodes(List<String> skuCodes);

    PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode);

    List<PsProductVO> findProdsByChnCodeSkuCode(String chnCode, String skuCode);

    /**
     * 根据SKU CODE查PROD，排除组合商品
     * @param skuCode
     * @return
     */
    PsProductVO findProdBySkuCode(String skuCode);
    List<PsProductVO> findProdBySkuCodes(List<String> skuCodes);


    /**
     * 根据SKU CODE查PROD，排除组合商品, 并匹配活动
     * @param skuCode
     * @return
     */
    PsProductVO findProdBySkuCode(String skuCode, PsMatchCampaignCond matchCampaignCond);

    List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, PsMatchCampaignCond matchCampaignCond);

    List<PsProductVO> findProdBySkuCodesWithStock(List<String> skuCodes, PsMatchCampaignCond matchCampaignCond);


    /**
     * 根据SKU CODE查PROD
     * @param skuCode
     * @param combined
     * @return
     */
    PsProductVO findProdBySkuCode(String skuCode, Boolean combined);
    PsProductVO findProdByCode( String code);
    List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, Boolean combined);
    PsProductVO findProdBySpvId(Long spvId);
    List<PsProductVO> findProdBySpvIds(List<Long> spvIds);
    List<PsProductVO> findOrderProdListBySpvIds(List<Long> spvIds);
    List<PsProductVO> findProdBySpvIds(List<Long> spvIds,List<String> returnFields, List<String> excludeFields);
    List<PsProductVO> findProdAndPutRedisBySpvIds(String chnCode,List<Long> spvIds,List<String> prodIds);
    List<PsProductVO> findProdWithSkuBySpvIds(List<Long> spvIds);

    List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode);

    /**
     * 查询推荐商品
     * @param chnCode
     * @param codes
     * @param campaignCond
     * @param currpage
     * @param pagenum
     * @return
     */
    List<PsProductVO> findRecommondProdByCodes(String chnCode, List<String> codes, final PsMatchCampaignCond campaignCond, int currpage, int pagenum);

    /**
     * 查询小程序推荐商品
     * @param chnCode
     * @param codes
     * @param matchCampaignCond
     * @param currpage
     * @param pagenum
     * @return
     */
    List<PsProductVO> findRecommondByCodesForApplet(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum);
    /**
     * 查询列表页商品
     * @param chnCode
     * @param codes
     * @param campaignCond
     * @param currpage
     * @param pagenum
     * @return
     */
    List<PsProductVO> findListPageByCodes(String chnCode, List<String> codes, final PsMatchCampaignCond campaignCond, int currpage, int pagenum);


    /**
     * 查询专题页商品
     * @param chnCode
     * @param codes
     * @param campaignCond
     * @param currpage
     * @param pagenum
     * @return
     */
    @Hotlink
    List<PsProductVO> findTopicByCodes(String chnCode, List<String> codes, final PsMatchCampaignCond campaignCond, int currpage, int pagenum);

    /**
     * 按CODE传入顺序查询多商品
     * @param chnCode
     * @param campaignCond
     * @return
     */
    //@Hotlink
    List<PsProductVO> findProdsByCodes(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    /**
     * 分页查询专题页商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findTopicBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    /**
     * 搜索商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    @Hotlink
    List<PsProductVO> findByProdSearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    /**
     * 搜索IPOS商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findIposProdBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    /**
     * 搜索野兽课堂商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findBeastCourseListBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);
    /**
     * 根据活动信息查询商品
     * @param campaignSearchCond
     * @return
     */
    List<PsProductVO> findByCampaignSearchCond(final PsCampaignSearchCond campaignSearchCond);

    List<PsProductVO> findCampaignProdBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);
    /**
     * 根据活动信息查询商品的赠品
     * @return
     */
    List<PsProductVO> findProdGiftBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);
    /**
     * 根据活动信息查询购物返礼的适用商品
     * @return
     */
    List<PsProductVO> findPromotionVoBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);


    List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode, final PsMatchCampaignCond campaignCond, int currpage, int pagenum);

    List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode);
    //like query
    List<PsProductVO> findByNameOrNameCN(Map<String, Object> params);

    List<PsProductVO> calculateDiscountPrice(List<PsProductVO> productList, PsMatchCampaignCond cond);

    PsProductVO calculateDiscountPrice(PsProductVO product, PsMatchCampaignCond cond);

//    PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond);

//	PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond,
//			List<PriceCalResultVO> results);

//    @Deprecated
//    PsSkuVO calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond);

//    PsSkuVO calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond);

    List<PsProductVO> findByChnCodeCateCodeCreateTime(String chnCode, Map<String,Date> dateRange,
                                                      PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum);

    @Hotlink
	Map<String, PsProductVO> mapByProdIds(List<String> prodIds);

    Map<String, PsProductVO> mapByProdCodes(List<String> codes);
    Map<String, PsProductVO> mapByProdCodes(List<String> codes,List<String> returnFields,List<String> excludeFields);

    /**
     * 获取商品详情
     * @param chnCode
     * @param productCode
     * @param matchCampaignCond
     * @return
     */
    @Hotlink
    PsProductVO getProductDetailByCode(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond);

    ProductKnowledgeVO getProductDetailByAi(String productCode);

    @Hotlink
    PsProductVO getProductDetailByCodeForCamp(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond);

//    @Hotlink
//    PsProductVO getProductDetailByCodeForCampNoFilter(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond);

    /**
     * 查询列表页折扣商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findDiscountListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 查询新人专享商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findNewMemberListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);


    /**
     * 查询列表页海淘商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findCrossBorderListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 查询列表页BU商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findBuListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    List<PsProductVO> findProdIdListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);
    /**
     * 查询列表页多品牌商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findBrandsListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 查询列表页定制商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findCustomzeListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 根据渠道查询新鲜上架类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryNewtCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询IPOS所有类目
     *
     * @param prodSearchCond
     * @return
     */
    List<PcsIposCategoryVO>  queryIposCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询折扣类目品牌标签(废弃)
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryDiscountCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询折扣类目品牌标签(废弃)
     *
     * @param prodSearchCond
     * @return
     */
    List<PcsSkuCategoryVO> queryDiscountSecondCategory(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);

    /**
     * 根据渠道查询折扣类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryDiscountCategoryBrandLabel(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);

    /**
     * 根据活动ID查询活动类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCampaginCategoryBrandLabel(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);

    /**
     * 根据活动ID查询活动赠品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCampaginGiftCategoryBrandLabel(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);

    /**
     * 根据活动ID查询活动赠品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryPromotionCategoryBrandLabel(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);

    /**
     * 去凑单查询活动赠品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO autoRecommendCategoryBrandLabel(ProdSearchCond prodSearchCond ,PsMatchCampaignCond matchCampaignCond);
    /**
     * 根据渠道查询海淘商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCrossBorderCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询BU商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryBuCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询专题页商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryTopicCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道查询多品牌商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryBrandsCategoryBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道分类查询商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByCodes(ProdSearchCond prodSearchCond);

    /**
     * 根据渠道品牌查询商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByBrandId(ProdSearchCond prodSearchCond);

    /**
     * 查询列表页特殊折扣商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findSpecialDiscountListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 查询列表页特殊折扣商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO querySpecialDiscountBrandLabel(ProdSearchCond prodSearchCond);

//    PsSpvVO getPsSpvVO(PsSpvVO spvVO,Map<String,PsStockVO> psStockVOMap, Map<String, PsPresaleSaleStockVO> psPresaleSaleStockVOMap);

//    PsSpvVO getPsSpvVO(PsSpvVO spvVO,Map<String,PsStockVO> psStockVOMap, Map<String, PsPresaleSaleStockVO> psPresaleSaleStockVOMap, Map<String,PsStockVO> psFurnitureStockVOMap);

//    Map<String,PsSkuVO> getPsSkuVOMap(List<PsSkuVO> skuList,Map<String,PsStockVO> psStockVOMap, Map<String, PsPresaleSaleStockVO> psPresaleSaleStockVOMap);

    Map<String,PsPresaleSaleStockVO> getPsPresaleSaleStockVOMap(List<String> skuCodes,OpChannelVO opChannelVO);

    Map<String,Integer> getPsPreSaleStockMap(List<String> prodCodes);

    /**
     * 返回APP上架的商品预售总库存
     * @param prodCodes
     * @return
     */
    Map<String,Integer> getPsProductAndPreSaleTotalStockMap(List<String> prodCodes);

    Map<String,PsStockVO> getPsStockVOMap(List<String> skuCodes,OpChannelVO opChannelVO);

    Map<String,PsStockVO> getPsFurnitureStockVOMap(List<String> skuCodes,OpChannelVO opChannelVO);

    Map<String,PsStockVO> getPsFurnitureStockVOMapByFurnitureCode(List<String> skuCodes,OpChannelVO opChannelVO,List<String> furnitureCodeList);
    /**
     * 查询列表页搜索类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryKeySearchBrandLabel(ProdSearchCond prodSearchCond);

    /**
     * 通过skuCode查找对应的product信息Map
     *
     * @param codes 待查找sku code
     *
     * @return skuCode为key,以及该skuCode对应的product信息
     */
    Map<String, PsProductVO> mapProductBySkuCodes(List<String> codes);

    Map<String, PsProductVO> mapProductBySkuCodes(String chnCode,PsMatchCampaignCond matchCampaignCond,List<String> codes);

    /**
     * 查询商品信息带SKU信息
     *
     * @param prodIds 待查找商品编号集合
     *
     * @return
     */
    Map<String, PsProductVO> mapByProdIdsWithSkuInfo(List<String> prodIds);

    /**
     * 查询商品信息带SKU信息
     *
     * @param codes 待查找商品编码集合
     *
     * @return
     */
    Map<String, PsProductVO> mapByProdCodesWithSkuInfo(List<String> codes);

    /**
     * 查询商品列表页根据SKU属性
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findProdListBySkuAttribute(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);
    /**
     * 根据渠道查询SKU属性商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryProdListCategoryBrandLabelBySkuAttribute(ProdSearchCond prodSearchCond);
    /**
     * 查询商品列表页根据标签
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findProdListByLabel(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);
    /**
     * 根据渠道查询标签商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryProdListCategoryBrandLabelByLabel(ProdSearchCond prodSearchCond);

    /**
     * 横滑商品
     * @param prodCodes
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findByNewProdSearchCondVO(List<String> prodCodes, ProdSearchCond prodSearchCond);

    List<PsProdCampVO> findProdCampBySkuCodes(List<String> skuCodes);

    /**
     * 根据渠道查询佣金商品类目品牌标签
     *
     * @param prodSearchCond
     * @return
     */
    PcsSkuCategoryBrandLabelVO queryCommissiontCategoryBrandLabel(ProdSearchCond prodSearchCond, PsMatchCampaignCond matchCampaignCond);
    /**
     * 查询列表页佣金商品
     * @param chnCode
     * @param matchCampaignCond
     * @param prodSearchCondVO
     * @return
     */
    List<PsProductVO> findCommissionuListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO);

    /**
     * 搜索商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findDeliveryByProdSearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    List<Date> getDeliveryByCond(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    /**
     * 搜索商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findByBackCategoryIds(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    List<PsProductVO> findByCouponSampleId(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    PcsSkuCategoryBrandLabelVO findByCouponSampleIdCategoryBrandLabel(ProdSearchCond prodSearchCond, PsMatchCampaignCond matchCampaignCond);
    //人工干预推荐
    List<PsProductVO> findActivityPageSortList(Long pageId);

    List<PsProductVO> getProdBySpvIdsFromRedis(String chnCode,List<Long> spvIds,List<String> prodIds);

    List<AppointProductVO> findAppointProdByCampaignId(Long campaignId, String chnCode);
    /**
     * 根据活动ID搜索指定商品
     * @param chnCode
     * @param campaignCond
     * @param prodSearchCond
     * @return
     */
    List<PsProductVO> findAppointProdBySearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);

    PcsSkuCategoryBrandLabelVO findAppointProdCategoryBrandLabel(ProdSearchCond prodSearchCond, PsMatchCampaignCond matchCampaignCond);
}
