package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pegasus.merchandise.enums.OpProdSkuAttributeLineStatusEnum;

public class OpProdSkuAttributeInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6639241967827981882L;
	
	private String attributeName;
	
	private Integer id;
	
	private Long creator;
	
	private Integer categoryId;
	
	private String categoryName;
	
	private String attributeCode;
	
	private Byte attributeStatus;
	
	private List<OpProdSkuAttributeLineInfo>  lineList;
	
	private String lineIds;
	
	private String lineNames;
	
	private String lineStatuss;
	
	
	

	public String getLineStatuss() {
		return lineStatuss;
	}

	public void setLineStatuss(String lineStatuss) {
		this.lineStatuss = lineStatuss;
	}

	public String getLineIds() {
		return lineIds;
	}

	public void setLineIds(String lineIds) {
		this.lineIds = lineIds;
	}

	public String getLineNames() {
		if(EmptyUtil.isNotEmpty(lineStatuss)) {
			String[] lineStatusArr = lineStatuss.split(",");
			String[] lineNameArr = lineNames.split(",");
			int arrSize = lineStatusArr.length;
			StringBuffer lineNamesBuf = new StringBuffer();
			for(int i = 0; i < arrSize; i ++) {
				String lineStatus = lineStatusArr[i];
				if(i != 0) {
					lineNamesBuf.append(",");
				}
				//审批中
				if(OpProdSkuAttributeLineStatusEnum.REVIEW.status == Byte.valueOf(lineStatus)) {
					lineNamesBuf.append("<font color='orange'>");
					lineNamesBuf.append(lineNameArr[i]);
					lineNamesBuf.append("</font>");
				} else if (OpProdSkuAttributeLineStatusEnum.REJECT.status == Byte.valueOf(lineStatus)) {
					lineNamesBuf.append("<font color='red'>");
					lineNamesBuf.append(lineNameArr[i]);
					lineNamesBuf.append("</font>");
				} else {
					lineNamesBuf.append(lineNameArr[i]);
				}
			}
			return lineNamesBuf.toString();
		}
		return lineNames;
	}

	public void setLineNames(String lineNames) {
		this.lineNames = lineNames;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Long getCreator() {
		return creator;
	}

	public void setCreator(Long creator) {
		this.creator = creator;
	}

	public String getAttributeName() {
		return attributeName;
	}

	public void setAttributeName(String attributeName) {
		this.attributeName = attributeName;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Integer getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Integer categoryId) {
		this.categoryId = categoryId;
	}

	public String getAttributeCode() {
		return attributeCode;
	}

	public void setAttributeCode(String attributeCode) {
		this.attributeCode = attributeCode;
	}

	public Byte getAttributeStatus() {
		return attributeStatus;
	}

	public void setAttributeStatus(Byte attributeStatus) {
		this.attributeStatus = attributeStatus;
	}

	public List<OpProdSkuAttributeLineInfo> getLineList() {
		
		if(lineIds != null && lineList == null) {
			List<OpProdSkuAttributeLineInfo> infoList = new ArrayList<OpProdSkuAttributeLineInfo>();
			String[] lineIdArray = lineIds.split(",");
			String[] lineNameArray = lineNames.split(",");
			int arrLength = lineIdArray.length;
			for(int i = 0; i < arrLength; i ++) {
				String lineId = lineIdArray[i];
				OpProdSkuAttributeLineInfo opProdSkuAttributeLineInfo = new OpProdSkuAttributeLineInfo();
				opProdSkuAttributeLineInfo.setId(Integer.parseInt(lineId));
				opProdSkuAttributeLineInfo.setLineName(lineNameArray[i]);
				infoList.add(opProdSkuAttributeLineInfo);
			}
			return infoList;
		}
		return lineList;
	}

	public void setLineList(List<OpProdSkuAttributeLineInfo> lineList) {
		this.lineList = lineList;
	}
	

}
