package com.thebeastshop.pegasus.merchandise.enums;

/**
 * Created by xiaodong.cheng on 2019/5/21.
 */
public enum SoldOutProdDisplayEnum {
    BOTTOM(0, "沉底"),
    FILTER(1, "过滤"),
    UN_CHANGED(2, "保持不变");

    private Integer type;
    private String desc;

    SoldOutProdDisplayEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static SoldOutProdDisplayEnum getEnumByType(Integer type) {
        for (SoldOutProdDisplayEnum soldOutProdDisplayEnum : SoldOutProdDisplayEnum.values()) {
            if (soldOutProdDisplayEnum.getType().equals(type)) {
                return soldOutProdDisplayEnum;
            }
        }
        return null;
    }
}
