package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 *  sku虚拟类型
 */
public enum PcsSkuVirtualTypeEnum {

    GENERAL(1, "普通编辑"),
    BEAST_CLASSROOM(2, "野兽课堂"),
    ;

    public final Integer type;
    public final String desc;

    public static final List<PcsSkuVirtualTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    PcsSkuVirtualTypeEnum(final Integer status, final String desc) {
        this.type = status;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuVirtualTypeEnum pcsSkuSpecialVarietyEnum : PcsSkuVirtualTypeEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", pcsSkuSpecialVarietyEnum.type);
            map.put("desc", pcsSkuSpecialVarietyEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    // 普通方法
    public static String getDesc(Integer status) {
        for (PcsSkuVirtualTypeEnum c : ALL) {
            if (c.type == status) {
                return c.desc;
            }
        }
        return null;
    }

    public final static Integer getTypeByDesc(String desc) {
        Integer statusVal = null;
        for (PcsSkuVirtualTypeEnum skuSpecialVarietyEnum : values()) {
            if (skuSpecialVarietyEnum.desc.equals(desc)) {
                statusVal = skuSpecialVarietyEnum.type;
                break;
            }
        }
        return statusVal;
    }

    public static PcsSkuVirtualTypeEnum getEnumById(Integer id) {
        PcsSkuVirtualTypeEnum[] values = PcsSkuVirtualTypeEnum.values();
        for (PcsSkuVirtualTypeEnum item : values) {
            if (item.getType().equals(id)) {
                return item;
            }
        }
        return null;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
