package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU特殊商品种类
 */
public enum PcsSkuItemLabelEnum {
    REGULAR("1", "常规款"),
    SEASONAL("2", "季节款"),
    LIMIT("3", "限量款");
    public final String type;
    public final String desc;


    public static final List<PcsSkuItemLabelEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    PcsSkuItemLabelEnum(final String status, final String desc) {
        this.type = status;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuItemLabelEnum pcsSkuSpecialVarietyEnum : PcsSkuItemLabelEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", pcsSkuSpecialVarietyEnum.type);
            map.put("desc", pcsSkuSpecialVarietyEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    // 普通方法
    public static String getDesc(String status) {
        for (PcsSkuItemLabelEnum c : ALL) {
            if (c.type.equals(status)) {
                return c.desc;
            }
        }
        return null;
    }

    public final static String getTypeByDesc(String desc) {
        String statusVal = null;
        for (PcsSkuItemLabelEnum skuSpecialVarietyEnum : values()) {
            if (skuSpecialVarietyEnum.desc.equals(desc)) {
                statusVal = skuSpecialVarietyEnum.type;
                break;
            }
        }
        return statusVal;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
