package com.thebeastshop.pegasus.merchandise.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * SKU默认发货仓1-香港仓,2-深圳仓
 */
public enum PcsSkuDefaultWarehouseEnum {
	HONGKONGWAREHOUSE(1, "香港仓"),
	SHENZHENWAREHOUSE(2, "深圳仓");

	private Integer val;

	private String desc;

	PcsSkuDefaultWarehouseEnum(Integer val, String desc) {
		this.val = val;
		this.desc = desc;
	}

	public final static List<PcsSkuDefaultWarehouseEnum> ALL = Arrays.asList(PcsSkuDefaultWarehouseEnum.values());

	public final static List<Map<String, Object>> listMap() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (PcsSkuDefaultWarehouseEnum pcsSkuDefaultWarehouseEnum : ALL) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", pcsSkuDefaultWarehouseEnum.val);
			map.put("name", pcsSkuDefaultWarehouseEnum.desc);
			list.add(map);
		}
		return list;
	}

	public static Integer isContainDesc(String desc) {
		for (PcsSkuDefaultWarehouseEnum pcsSkuDefaultWarehouseEnum : ALL) {
			if (pcsSkuDefaultWarehouseEnum.desc.equals(desc)) {
				return pcsSkuDefaultWarehouseEnum.val;
			}
		}
		return null;
	}

	public final static String getClearanceWayDesc(Integer val) {
		if (val == null) {
			return "";
		}
		for (PcsSkuDefaultWarehouseEnum pcsSkuDefaultWarehouseEnum : ALL) {
			if (val == pcsSkuDefaultWarehouseEnum.val) {
				return pcsSkuDefaultWarehouseEnum.desc;
			}
		}
		return "";
	}

	public Integer getVal() {
		return val;
	}

	public String getDesc() {
		return desc;
	}
}
