package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.service.ApprovalRecordService;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponApprovalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Desc:
 * Created by hafiz.zhang on 2016/7/7.
 */
@Service
public class CouponApprovalServiceImpl extends BaseService implements CouponApprovalService {

    @Autowired
    private ApprovalRecordService approvalRecordService;

    @Autowired
    private CouponSampleDao couponSampleDao;

    @Override
    public ApprovalRecord create(ApprovalRecord domain) {
        return approvalRecordService.create(domain);
    }

    @Override
    public List<ApprovalRecord> getApprovalByPendingId(Long pendingId) {
        return approvalRecordService.listApprovalRecordByPendingId(pendingId, ApprovalType.COUPON.getId());
    }

    @Transactional
    @Override
    public Boolean agreePendingCouponSample(ApprovalRecord domain) {
        Integer result = 0;
        Integer level = 0;
        if(null != domain.getCouponApprovalLevel()) {
            level = domain.getCouponApprovalLevel().getId();
        }
        Long pendingId = domain.getPendingId();
        if(1 == level) {
            //若为第一级审批，则把该优惠券状态变为“审批中”
            result = couponSampleDao.changeCouponSampleState(pendingId, 2);
        } else if(2 == level){
            //若为第二级审批，则把该优惠券状态变为“可领取”
            result = couponSampleDao.changeCouponSampleState(pendingId, 4);
        }
        if(result > 0) {
            ApprovalRecord newCouponApproval = approvalRecordService.create(domain);
            if(null == newCouponApproval || null == newCouponApproval.getId()) {
                logger.info("插入优惠券审批记录失败");
                return false;
            }
            return true;
        } else {
            logger.info("修改审批等级为：" + level + "的优惠券模板状态失败");
            return false;
        }
    }

    @Transactional
    @Override
    public Boolean rejectPendingCouponSample(ApprovalRecord domain) {
        Integer level = 0;
        if(null != domain.getCouponApprovalLevel()) {
            level = domain.getCouponApprovalLevel().getId();
        }
        Long pendingId = domain.getPendingId();
        //驳回时把该优惠券的状态变为“审批不通过”
        if(couponSampleDao.changeCouponSampleState(pendingId, 3) > 0) {
            ApprovalRecord newCouponApproval = approvalRecordService.create(domain);
            if(null == newCouponApproval || null == newCouponApproval.getId()) {
                logger.info("插入优惠券审批记录失败");
                return false;
            }
            return true;
        } else {
            logger.info("修改审批等级为：" + level + "的优惠券模板状态为[审批不通过]失败");
            return false;
        }
    }
}
