package com.thebeastshop.pegasus.component.coupon.domain.impl;

import java.util.Objects;

import com.thebeastshop.pegasus.component.coupon.domain.Coupon;

/**
 * @author Liang Wenjian
 */
public abstract class CouponTemplate implements Coupon {

	public CouponTemplate() {
		super();
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof Coupon)) {
			return false;
		}
		final Coupon that = (Coupon) o;
		return Objects.equals(getId(), that.getId());
	}

	@Override
	public int hashCode() {
		return Objects.hash(getId());
	}

	@Override
	public String toString() {
		return "DefaultCouponImpl [couponSampleId=" + getCouponSampleId() + ", isUsed=" + isUsed() + ", note="
				+ getNote() + ", isValid=" + isValid() + ", ownerId=" + getOwnerId() + ", id=" + getId()
				+ ", createTime=" + getCreateTime() + ", expireTime=" + getExpireTime() + ", startTime="
				+ getStartTime() + "]";
	}
}
