package com.thebeastshop.pegasus.component.coupon.condition;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleEntityExample.Criteria;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * 优惠券模板查询条件
 * 
 * @author Paul-xiong
 *
 */
public class CouponSampleCondition {

	private Long id;

	private Integer couponType;

	private String name;

	private Integer stateId;


	public void fillCriteria(Criteria criteria) {
		if (id != null) {
			criteria.andIdEqualTo(id);
		}
		if (couponType != null) {
			criteria.andCouponTypeEqualTo(couponType);
		}
		if (StringUtils.isNotEmpty(name)) {
			criteria.andNameLike(name);
		}
		if (stateId != null) {
			if (stateId == CouponSampleState.FINISH.getId()) {
				criteria.andBalanceCountEqualTo(0);
				criteria.andStateIdIn(Arrays.asList(new Integer[] {4, 5}));
			}
			else {
				criteria.andStateIdEqualTo(stateId);
			}
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getCouponType() {
		return couponType;
	}

	public void setCouponType(Integer couponType) {
		this.couponType = couponType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getStateId() {
		return stateId;
	}

	public void setStateId(Integer stateId) {
		this.stateId = stateId;
	}
}
