package com.thebeastshop.pegasus.component.coupon.service.impl;

import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeDao;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class CouponCodeServiceImpl extends BaseService implements CouponCodeService {

	@Autowired
	private CouponCodeDao dao;

	@Override
	public List<CouponCode> generate(long couponSampleId, int count, long creatorId) {
		List<CouponCode> objs = Lists.newLinkedList();
		for (int i = 0; i < count; i++) {
			DefaultCouponCodeImpl code = new DefaultCouponCodeImpl();
			code.setCouponSampleId(couponSampleId);
			code.setCode(UUID.randomUUID().toString().replace("-", "").substring(0, 4));
			code.setCreateTime(new Date());
			code.setCreatorId(creatorId);
			code.setNote("");
			objs.add(code);
		}
		this.create(objs);
		return null;
	}

	@Override
	public CouponCode create(CouponCode obj) {
		return this.dao.create(obj);
	}

	@Override
	public List<CouponCode> create(List<CouponCode> objs) {
		return this.dao.create(objs);
	}

	@Override
	public CouponCode getByCode(String code) {
		return this.dao.getByCode(code);
	}

	@Override
	public CouponCode getByCouponSampleId(Long id) {
		return this.dao.getByCouponSampleId(id);
	}

}
