package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.State;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author Liang Wenjian
 */
public enum CouponSampleState implements State {
    WAIT_FOR_APPROVE(1, "待审批"),
    APPROVING(2, "审批中"),
    APPROVE_NOT_PASS(3, "审批不通过"),
    ONLINE(4, "可领取"),
    INVALID(5, "废弃"),
    DRAFT(-1, "草稿");

    final Integer id;
    final String name;

    public static final List<CouponSampleState> ALL = Collections.unmodifiableList(Arrays.asList(values()));


    CouponSampleState(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
