package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 审批结果
 *
 * Created by hafiz.zhang on 2016/7/6.
 */
public enum CouponApprovalResult implements HasIntIdGetter, HasName {
    SUCCESS(1, "通过"),
    REJECT(0, "驳回");
    private final Integer id;
    private final String name;
    public static final List<CouponApprovalResult> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    CouponApprovalResult(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
