package com.thebeastshop.pegasus.component.coupon.domain;

import java.util.Collection;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasCreatorId;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.mark.HasNote;
import com.thebeastshop.support.mark.HasState;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.mark.WillExpire;

/**
 * 优惠券模板。 发到会员手中的优惠券就是以此为模板。
 *
 * @author Liang Wenjian
 */
@JsonDeserialize(as = DefaultCouponSampleImpl.class)
public interface CouponSample
		extends HasLongIdGetter, HasName, HasCreateTime, HasCreatorId, WillExpire, HasState, HasNote {

	String getTitle();

	/**
	 * 优惠券类型
	 *
	 * @return
	 */
	CouponType getCouponType();

	/**
	 * 适用商品简述
	 * 
	 * @return
	 */
	String getProductDesc();

	/**
	 * 详细信息
	 *
	 * @return
	 */
	String getDescription();

	/**
	 * 这种优惠券最多能创建多少个
	 *
	 * @return
	 */
	Integer getMaxCount();

	/**
	 * 剩余未领取数量
	 * 
	 * @return
	 */
	Integer getBalanceCount();

	/**
	 * 每位用户限领数量。
	 *
	 * @return
	 */
	Integer getMaxPerMember();

	/**
	 * 适用平台
	 *
	 * @return
	 */
	Collection<AccessWay> getAccessWays();

	/**
	 * 发放方式
	 *
	 * @return
	 */
	CouponSendWay getCouponSendWay();

	/**
	 * 优惠内容 (JSON格式字符串)
	 *
	 * @return
	 */
	String getCouponContentJSON();

	/**
	 * 优惠内容
	 * 
	 * @return 优惠类型为满减情况：返回json数据格式 {"fullPrice":100,"cutPrice":20}
	 */
	CouponContent getCouponContent();

	/**
	 * 获取可用本券的适用类目id集。
	 *
	 * @return 若不限商品则返回null。
	 */
	Collection<Long> getCategoryIds();

	/**
	 * 获取可用本券的适用商品id集。
	 *
	 * @return 若适用类目不为null或不限商品则返回null。
	 */
	Collection<Long> getProductIds();

	/**
	 * 获取全场券的排除商品id集。
	 *
	 * @return 若适用类目不为null或适用商品不为null则返回null。
	 */
	Collection<Long> getExcludeProductIds();

	/**
	 * 状态
	 *
	 * @return
	 */
	int getStateId();

	@Override
	State getState();

	/**
	 * 是否对所有商品有效
	 *
	 * @return
	 */
	boolean isForAllProducts();
}
