package com.thebeastshop.pegasus.component.coupon.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.ApprovalRecordDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.ApprovalRecordEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultApprovalRecordImpl;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalLevel;
import com.thebeastshop.pegasus.component.coupon.enums.CouponApprovalResult;
import com.thebeastshop.pegasus.component.coupon.model.ApprovalRecordEntity;
import com.thebeastshop.support.util.EnumUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by hafiz.zhang on 2016/7/6.
 */
@Repository
public class ApprovalRecordDaoImpl implements ApprovalRecordDao {
    private Logger logger = LoggerFactory.getLogger(ApprovalRecordDaoImpl.class);

    @Autowired
    private ApprovalRecordEntityMapper mapper;

    /**
     * domain to entity
     *
     * @param domain 待转换的domain对象
     *
     * @return 已转换的entity对象
     */
    private ApprovalRecordEntity domain2Entity(ApprovalRecord domain) {
        ApprovalRecordEntity entity = new ApprovalRecordEntity();
        entity.setId(domain.getId());
        entity.setApproverId(domain.getCreatorId());
        entity.setType(domain.getType());
        entity.setNickName(domain.getNickName());
        entity.setPendingId(domain.getPendingId());
        entity.setOpinion(domain.getOpinion());
        if(null != domain.getCouponApprovalLevel()) {
            entity.setLevel(domain.getCouponApprovalLevel().getId());
        }
        if(null != domain.getCouponApprovalResult()) {
            entity.setResult(domain.getCouponApprovalResult().getId());
        }
        entity.setCreateTime(domain.getCreateTime());
        return entity;
    }

    /**
     * entity to domain
     *
     * @param entity 待转换的entity对象
     *
     * @return 转换后的domain对象
     */
    private ApprovalRecord entity2Domain(ApprovalRecordEntity entity) {
        if(null == entity) {
            return null;
        }
        DefaultApprovalRecordImpl domain = new DefaultApprovalRecordImpl();
        domain.setId(entity.getId());
        domain.setNickName(entity.getNickName());
        domain.setCreatorId(entity.getApproverId());
        domain.setPendingId(entity.getPendingId());
        domain.setType(EnumUtil.valueOf(entity.getType(), ApprovalType.class));
        domain.setCouponApprovalLevel(EnumUtil.valueOf(entity.getLevel(), CouponApprovalLevel.class));
        domain.setCouponApprovalResult(EnumUtil.valueOf(entity.getResult(), CouponApprovalResult.class));
        domain.setOpinion(entity.getOpinion());
        domain.setCreateTime(entity.getCreateTime());
        return domain;
    }

    /**
     * 批量转换entity to domain
     *
     * @param entities  待转换的entitys
     *
     * @return  转换后的domains
     */
    private List<ApprovalRecord> entity2Domain(List<ApprovalRecordEntity> entities){
        if(null == entities) {
           return null;
        }
        List<ApprovalRecord> domains = Lists.newArrayList();
        for(ApprovalRecordEntity entity : entities) {
            domains.add(entity2Domain(entity));
        }
        return domains;
    }

    /**
     * 创建审批记录
     *
     * @param couponApproval    待创建审批记录
     *
     * @return  创建的审批记录
     */
    @Override
    public ApprovalRecord create(ApprovalRecord couponApproval) {
        logger.info("Creating CouponApproval: {}" + couponApproval);
        ApprovalRecordEntity entity = domain2Entity(couponApproval);
        if (null != entity) {
            entity.setCreateTime(new Date());
            Integer count = this.mapper.insertSelective(entity);

            if(count > 0) {
                couponApproval = entity2Domain(entity);
                logger.info("Created CouponApproval: {}" + couponApproval);
                return couponApproval;
            }
        }
        return null;
    }

    @Override
    public List<ApprovalRecord> getApprovalByPendingId(Long pendingId, Integer type) {
        return entity2Domain(this.mapper.getApprovalByPendingId(pendingId, type));
    }

}
