package com.thebeastshop.pegasus.component.coupon.dao;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface CouponCodeDao {
	/**
	 * 创建优惠码
	 * 
	 * @param obj
	 * @return
	 */
	CouponCode create(CouponCode obj);

	/**
	 * 创建一批优惠码
	 * 
	 * @param objs
	 * @return
	 */
	List<CouponCode> create(List<CouponCode> objs);
	
	/**
	 * 根据优惠口令获取优惠码
	 * 
	 * @param code
	 *            优惠口令
	 * @return
	 */
	CouponCode getByCode(String code);

	CouponCode getByCouponSampleId(Long id);
}
