/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCount;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponImpl;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.model.CouponCountEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponEntityExample;
import com.thebeastshop.support.AccessWay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CouponDaoImpl
implements CouponDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CouponEntityMapper mapper;

    private CouponEntity domain2Entity(Coupon obj) {
        CouponEntity entity = new CouponEntity();
        entity.setCouponSampleId(obj.getCouponSampleId());
        entity.setCreateTime(obj.getCreateTime());
        entity.setExpireTime(obj.getExpireTime());
        entity.setId(obj.getId());
        entity.setIsUsed(obj.isUsed());
        entity.setIsValid(obj.isValid());
        entity.setNote(obj.getNote());
        entity.setOwnerId(obj.getOwnerId());
        entity.setStartTime(obj.getStartTime());
        return entity;
    }

    private Coupon entity2Domain(CouponEntity entity) {
        DefaultCouponImpl obj = new DefaultCouponImpl();
        obj.setCouponSampleId(entity.getCouponSampleId());
        obj.setCreateTime(entity.getCreateTime());
        obj.setExpireTime(entity.getExpireTime());
        obj.setId(entity.getId());
        obj.setUsed(entity.getIsUsed());
        obj.setValid(entity.getIsValid());
        obj.setNote(entity.getNote());
        obj.setOwnerId(entity.getOwnerId());
        obj.setStartTime(entity.getStartTime());
        String sampleName = entity.getSampleName();
        if (StringUtils.isNotEmpty((String)sampleName)) {
            Object[] categoryIdStrList;
            String categoryIds;
            Object[] productIdStrList;
            String productIds;
            String sendWay;
            Object[] accessWayIds;
            DefaultCouponSampleImpl couponSample = new DefaultCouponSampleImpl();
            couponSample.setId(entity.getCouponSampleId());
            couponSample.setName(sampleName);
            couponSample.setTitle(entity.getSampleTitle());
            couponSample.setCouponContent(entity.getCouponContent());
            couponSample.setBalanceCount(entity.getBalanceCount());
            couponSample.setStateId(entity.getSampleStateId());
            couponSample.setDescription(entity.getSampleDescription());
            couponSample.setMaxCount(entity.getMaxCount());
            couponSample.setMaxPerMember(entity.getMaxPerMember());
            couponSample.setNote(entity.getSampleNote());
            couponSample.setCreateTime(entity.getSampleCreateTime());
            couponSample.setCreatorId(entity.getSampleCreatorId());
            couponSample.setExpireTime(entity.getSampleExpireTime());
            String accessWays = entity.getAccessWays();
            if (StringUtils.isNotEmpty((String)accessWays) && ArrayUtils.isNotEmpty((Object[])(accessWayIds = accessWays.split(",")))) {
                ArrayList<AccessWay> accessWayList = new ArrayList<AccessWay>();
                for (Object accessWayId : accessWayIds) {
                    AccessWay accessWay = AccessWay.valueOf((int)Integer.valueOf((String)accessWayId));
                    accessWayList.add(accessWay);
                }
                couponSample.setAccessWays(accessWayList);
            }
            if (StringUtils.isNotEmpty((String)(sendWay = entity.getCouponSendWay()))) {
                couponSample.setCouponSendWay(CouponSendWay.valueOf(Integer.valueOf(sendWay)));
            }
            if (StringUtils.isNotEmpty((String)(productIds = entity.getProductIds())) && ArrayUtils.isNotEmpty((Object[])(productIdStrList = productIds.split(",")))) {
                ArrayList<Long> productIdList = new ArrayList<Long>();
                for (Object productIdStr : productIdStrList) {
                    productIdList.add(Long.valueOf((String)productIdStr));
                }
                couponSample.setProductIds(productIdList);
            }
            if (StringUtils.isNotEmpty((String)(categoryIds = entity.getCategoryIds())) && ArrayUtils.isNotEmpty((Object[])(categoryIdStrList = categoryIds.split(",")))) {
                ArrayList<Long> categoryIdList = new ArrayList<Long>();
                for (Object categoryIdStr : categoryIdStrList) {
                    categoryIdList.add(Long.valueOf((String)categoryIdStr));
                }
                couponSample.setCategoryIds(categoryIdList);
            }
            obj.setCouponSample(couponSample);
        }
        return obj;
    }

    private List<Coupon> entity2Domain(List<CouponEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        for (CouponEntity entity : entities) {
            domains.add(this.entity2Domain(entity));
        }
        return domains;
    }

    private void fillCriteria(CouponEntityExample.Criteria criteria, CouponCondition condition) {
        if (condition.getOwnerId() != null) {
            criteria.andOwnerIdEqualTo(condition.getOwnerId());
        }
        if (condition.getCouponSampleId() != null) {
            criteria.andCouponSampleIdEqualTo(condition.getCouponSampleId());
        }
        if (condition.getIsUsed() != null) {
            criteria.andIsUsedEqualTo(condition.getIsUsed());
        }
        if (condition.getIsValid() != null) {
            criteria.andIsValidEqualTo(condition.getIsValid());
        }
    }

    @Override
    public Coupon getById(long id) {
        return this.entity2Domain(this.mapper.selectById(id));
    }

    @Override
    public List<Coupon> getCoupons(long ownerId) {
        CouponCondition condition = new CouponCondition();
        condition.setOwnerId(ownerId);
        return this.getCouponsByCondition(condition);
    }

    @Override
    public List<Coupon> getCoupons(long ownerId, Long couponSampleId) {
        CouponCondition condition = new CouponCondition();
        condition.setOwnerId(ownerId);
        condition.setCouponSampleId(couponSampleId);
        return this.getCouponsByCondition(condition);
    }

    @Override
    public List<Coupon> getUsableCoupons(long ownerId) {
        CouponEntityExample example = new CouponEntityExample();
        example.createCriteria().andIsValidEqualTo(true).andIsUsedEqualTo(false).andOwnerIdEqualTo(ownerId).andStartTimeLessThanOrEqualTo(new Date()).andExpireTimeGreaterThanOrEqualTo(new Date());
        List<CouponEntity> entityList = this.mapper.selectByExample(example);
        return this.entity2Domain(entityList);
    }

    @Override
    public List<Coupon> getExpiredCoupons(long ownerId) {
        CouponEntityExample example = new CouponEntityExample();
        example.createCriteria().andOwnerIdEqualTo(ownerId).andIsValidEqualTo(true).andIsUsedEqualTo(false).andExpireTimeLessThan(new Date());
        List<CouponEntity> entityList = this.mapper.selectByExample(example);
        return this.entity2Domain(entityList);
    }

    @Override
    public List<Coupon> getUsedCoupons(long ownerId) {
        CouponCondition condition = new CouponCondition();
        condition.setOwnerId(ownerId);
        condition.setIsValid(true);
        condition.setIsUsed(true);
        return this.getCouponsByCondition(condition);
    }

    @Override
    public List<Coupon> getCouponsByCondition(CouponCondition condition) {
        List<CouponEntity> entityList = this.mapper.selectByCondition(condition);
        return this.entity2Domain(entityList);
    }

    @Override
    public CouponCount countCouponByCondition(CouponCondition condition) {
        CouponCountEntity couponCountEntity = this.mapper.countCouponByCondition(condition);
        if (couponCountEntity == null) {
            CouponCount emptyCoupontCount = new CouponCount();
            emptyCoupontCount.setUnusedCount(0);
            emptyCoupontCount.setUsedCount(0);
            emptyCoupontCount.setExpiredCount(0);
            emptyCoupontCount.setUnexpiredCount(0);
            return emptyCoupontCount;
        }
        CouponCount couponCount = new CouponCount();
        couponCount.setUnusedCount(couponCountEntity.getUnusedCount());
        couponCount.setUsedCount(couponCountEntity.getUsedCount());
        couponCount.setExpiredCount(couponCountEntity.getExpiredCount());
        couponCount.setUnexpiredCount(couponCountEntity.getUnexpiredCount());
        return couponCount;
    }

    @Override
    public Coupon create(Coupon coupon) {
        this.logger.info("Creating Coupon: {}", (Object)coupon);
        CouponEntity entity = this.domain2Entity(coupon);
        if (entity != null) {
            entity.setCreateTime(new Date());
            int count = this.mapper.insertSelective(entity);
            if (count > 0) {
                this.logger.info("Created Coupon: {}", (Object)coupon);
                return this.entity2Domain(entity);
            }
        }
        return null;
    }

    @Override
    public Boolean update(Coupon obj) {
        int count;
        this.logger.info("Updating Coupon: {}", (Object)obj);
        CouponEntity entity = this.domain2Entity(obj);
        if (entity != null && (count = this.mapper.updateByPrimaryKeySelective(entity)) > 0) {
            this.logger.info("Updated Coupon: {}", (Object)obj);
            return true;
        }
        return false;
    }

    @Override
    public int getCouponsCount(long ownerId) {
        return this.getCoupons(ownerId).size();
    }

    @Override
    public int getCouponsCount(long ownerId, Long couponSampleId) {
        return this.getCoupons(ownerId, couponSampleId).size();
    }

    @Override
    public int getUsableCouponsCount(long ownerId) {
        return this.getUsableCoupons(ownerId).size();
    }

    @Override
    public int getExpiredCouponsCount(long ownerId) {
        return this.getExpiredCoupons(ownerId).size();
    }

    @Override
    public int getUsedCouponsCount(long ownerId) {
        return this.getUsedCoupons(ownerId).size();
    }

    @Override
    public Collection<Coupon> create(Collection<Coupon> coupons) {
        ArrayList list = Lists.newArrayList();
        for (Coupon coupon : coupons) {
            list.add(this.create(coupon));
        }
        return list;
    }
}

