/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponCodeExchangeCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeExchangeDao;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCodeExchange;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeExchangeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.support.exception.WrongArgException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponCodeExchangeServiceImpl
extends BaseService
implements CouponCodeExchangeService {
    @Autowired
    private CouponSampleService couponSampleService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponCodeService couponCodeService;
    @Autowired
    private CouponCodeExchangeDao dao;

    @Override
    @Transactional
    public CouponCodeExchange exchange(CouponCodeExchange exchange) {
        String code = exchange.getCode();
        if (StringUtils.isBlank((String)code)) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u53e3\u4ee4\u4e3a\u7a7a", "code", (Object)code);
        }
        CouponCode couponCode = this.couponCodeService.getByCode(code);
        if (couponCode == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u53e3\u4ee4\u65e0\u6548", "code", (Object)code);
        }
        CouponSample couponSample = this.couponSampleService.getById(couponCode.getCouponSampleId());
        if (!CouponSampleState.ONLINE.equals(couponSample.getState())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u5df2\u5931\u6548", "state", (Object)couponSample.getState());
        }
        CouponCodeExchangeCondition condition = new CouponCodeExchangeCondition();
        condition.setOwnerId(exchange.getOwnerId());
        condition.setCouponSampleId(couponCode.getCouponSampleId());
        if (this.getByCondition(condition).iterator().hasNext()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u53e3\u4ee4\u5df2\u4f7f\u7528", "code", (Object)code);
        }
        Coupon coupon = this.couponService.send(couponSample, exchange.getOwnerId());
        CouponCodeExchange createObj = new CouponCodeExchange();
        createObj.setCode(code);
        createObj.setCouponId(coupon.getId());
        createObj.setCouponSampleId(couponSample.getId());
        createObj.setOwnerId(exchange.getOwnerId());
        return this.create(createObj);
    }

    @Override
    public List<CouponCodeExchange> getByCondition(CouponCodeExchangeCondition condition) {
        return this.dao.getByCondition(condition);
    }

    @Override
    public CouponCodeExchange create(CouponCodeExchange exchange) {
        return this.dao.create(exchange);
    }
}

