/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.condition.PendingCouponCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.mark.State;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponSampleServiceImpl
extends BaseService
implements CouponSampleService {
    @Autowired
    private CouponSampleDao couponSampleDao;

    @Override
    public CouponSample create(CouponSample obj) {
        return this.couponSampleDao.create(obj);
    }

    @Override
    public boolean update(CouponSample obj) {
        return this.couponSampleDao.update(obj);
    }

    @Override
    public boolean delete(Long id) {
        return false;
    }

    @Override
    public CouponSample getById(long id) {
        CouponSample obj = this.couponSampleDao.getById(id);
        if (obj == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728", "id", (Object)id);
        }
        return obj;
    }

    @Override
    public List<State> getStates() {
        return Lists.newArrayList((Object[])CouponSampleState.values());
    }

    @Override
    public List<CouponSendWay> getCouponSendWays() {
        return Arrays.asList(CouponSendWay.values());
    }

    @Override
    public List<AccessWay> getAccessWays() {
        return Arrays.asList(AccessWay.values());
    }

    @Override
    public List<CouponSample> getByCondition(CouponSampleCondition condition) {
        return this.couponSampleDao.getByCondition(condition);
    }

    @Override
    public List<CouponSample> getFirstPendingCouponSample(PendingCouponCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.couponSampleDao.getFirstApprovaledCouponSample();
        }
        if (0 == type) {
            return this.couponSampleDao.getFirstPendingCouponSample();
        }
        return null;
    }

    @Override
    public List<CouponSample> getSecondPendingCouponSample(PendingCouponCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.couponSampleDao.getSecondApprovaledCouponSample();
        }
        if (0 == type) {
            return this.couponSampleDao.getSecondPendingCouponSample();
        }
        return null;
    }

    @Override
    public CouponSample checkById(long id) {
        CouponSample one = this.getById(id);
        if (one == null) {
            throw new NoSuchResourceException("\u4f18\u60e0\u5238\u6837\u677f", (Object)id);
        }
        return one;
    }
}

