package com.thebeastshop.pegasus.component.coupon.service.impl;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.mark.State;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class CouponSampleServiceImpl extends BaseService implements CouponSampleService {
	@Autowired
	private CouponSampleDao couponSampleDao;

	@Override
	public CouponSample create(CouponSample obj) {
		return this.couponSampleDao.create(obj);
	}

	@Override
	public boolean update(CouponSample obj) {
		return this.couponSampleDao.update(obj);
	}

	@Override
	public boolean delete(Long id) {
		return false;
	}

	@Override
	public CouponSample getById(final long id) {
		CouponSample obj = this.couponSampleDao.getById(id);
		if (obj == null) {
			throw new WrongArgException("优惠券模板不存在", "id", id);
		}
		return obj;
	}

	@Override
	public List<State> getStates() {
		return Lists.<State> newArrayList(CouponSampleState.values());
	}

	@Override
	public List<CouponSendWay> getCouponSendWays() {
		return Arrays.asList(CouponSendWay.values());
	}

	@Override
	public List<AccessWay> getAccessWays() {
		return Arrays.asList(AccessWay.values());
	}

	@Override
	public List<CouponSample> getByCondition(CouponSampleCondition condition) {
		return this.couponSampleDao.getByCondition(condition);
	}

	@Override
	public CouponSample checkById(long id) {
		final CouponSample one = getById(id);
		if (one == null) {
			throw new NoSuchResourceException("优惠券样板", id);
		}
		return one;
	}

}
