package com.thebeastshop.pegasus.component.coupon.service;

import java.util.List;

import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface CouponCodeService {
	/**
	 * 根据优惠券模板生成优惠码
	 * 
	 * @param couponSampleId
	 *            优惠券模板id
	 * @param count
	 *            生成数量
	 * @param creatorId
	 *            操作人id
	 * @return
	 */
	List<CouponCode> generate(long couponSampleId, int count, long creatorId);

	/**
	 * 创建优惠码
	 * 
	 * @param obj
	 * @return
	 */
	CouponCode create(CouponCode obj);

	/**
	 * 创建一批优惠码
	 * 
	 * @param objs
	 * @return
	 */
	List<CouponCode> create(List<CouponCode> objs);

	/**
	 * 根据优惠口令获取优惠码
	 * 
	 * @param code
	 *            优惠口令
	 * @return
	 */
	CouponCode getByCode(String code);

}
