package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.State;

/**
 * @author Liang Wenjian
 */
public enum CouponSampleState implements State {
    WAIT_FOR_APPROVE(1, "待审批"),
    APPROVING(2, "审批中"),
    APPROVE_NOT_PASS(3, "审批不通过"),
    ONLINE(4, "可领取"),
    INVALID(5, "废弃");

    final Integer id;
    final String name;

    CouponSampleState(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
