package com.thebeastshop.pegasus.component.coupon.dao.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeEntityExample;

/**
 * 
 * @author Paul-xiong
 *
 */
@Repository
public class CouponCodeDaoImpl implements CouponCodeDao {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private CouponCodeEntityMapper mapper;

	/**
	 * domain to entity
	 * 
	 * @param obj
	 *            CouponCode对象
	 * @return
	 */
	private CouponCodeEntity domain2Entity(CouponCode obj) {
		CouponCodeEntity entity = new CouponCodeEntity();
		entity.setCode(obj.getCode());
		entity.setCouponSampleId(obj.getCouponSampleId());
		entity.setCreateTime(obj.getCreateTime());
		entity.setCreatorId(obj.getCreatorId());
		entity.setId(obj.getId());
		entity.setNote(obj.getNote());
		return entity;
	}

	/**
	 * entity to domain
	 * 
	 * @param entity
	 *            CouponCodeEntity对象
	 * @return
	 */
	private CouponCode entity2Domain(CouponCodeEntity entity) {
		DefaultCouponCodeImpl obj = new DefaultCouponCodeImpl();
		obj.setCode(entity.getCode());
		obj.setCouponSampleId(entity.getCouponSampleId());
		obj.setCreateTime(entity.getCreateTime());
		obj.setCreatorId(entity.getCreatorId());
		obj.setId(entity.getId());
		obj.setNote(entity.getNote());
		return obj;
	}

	@Override
	public CouponCode create(CouponCode obj) {
		logger.info("Creating CouponCode: {}", obj);

		CouponCodeEntity entity = this.domain2Entity(obj);
		if (entity != null) {
			entity.setCreateTime(new Date());
			int count = this.mapper.insertSelective(entity);

			if (count > 0) {
				obj = this.entity2Domain(entity);
				logger.info("Created CouponCode: {}", obj);
				return obj;
			}
		}

		return null;
	}

	@Override
	public List<CouponCode> create(List<CouponCode> objs) {
		logger.info("Creating CouponCodes: {}", objs);
		List<CouponCodeEntity> entitys = Lists.newArrayList();
		for (CouponCode couponCode : objs) {
			CouponCodeEntity entity = this.domain2Entity(couponCode);
			entity.setCreateTime(new Date());
			entitys.add(entity);
		}

		int count = this.mapper.insertList(entitys);
		if (count > 0) {
			List<CouponCode> rtObjs = Lists.newArrayList();
			for (CouponCodeEntity entity : entitys) {
				rtObjs.add(this.entity2Domain(entity));
			}
			logger.info("Created CouponCodes: {}", rtObjs);
			return rtObjs;
		}

		return Lists.newArrayList();
	}

	@Override
	public CouponCode getByCode(String code) {
		CouponCodeEntityExample example = new CouponCodeEntityExample();
		example.createCriteria().andCodeEqualTo(code);
		List<CouponCodeEntity> list = this.mapper.selectByExample(example);
		if (CollectionUtils.isNotEmpty(list)) {
			return this.entity2Domain(list.get(0));
		}
		return null;
	}

}
