package com.thebeastshop.pegasus.component.coupon;

import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.pegasus.component.coupon.service.CouponCodeExchangeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.pegasus.component.coupon.support.SpringUtil;
import com.thebeastshop.pegasus.component.coupon.support.lock.PegasusFacadeLock;

/**
 * 收藏服务外观器
 * 
 * @author Paul-xiong
 *
 */
public class PegasusCouponServiceFacade {

	// private final Logger logger =
	// LoggerFactory.getLogger(PegasusAppServiceFacade.class);

	private static PegasusCouponServiceFacade instance;

	@Autowired
	private CouponCodeExchangeService couponCodeExchangeService;

	@Autowired
	private CouponService couponService;

	@Autowired
	private CouponCodeService couponCodeService;

	@Autowired
	private CouponSampleService couponSampleService;

	public static PegasusCouponServiceFacade getInstance() {
		if (instance != null) {
			return instance;
		}

		synchronized (PegasusFacadeLock.class) {
			if (instance == null) {
				instance = (PegasusCouponServiceFacade) SpringUtil.getBean("pegasusCouponServiceFacade");
			}
		}
		return instance;
	}

	public CouponService getCouponService() {
		return couponService;
	}
	
	public CouponSampleService getCouponSampleService() {
		return couponSampleService;
	}

	public CouponCodeService getCouponCodeService() {
		return couponCodeService;
	}
	
	public CouponCodeExchangeService getCouponCodeExchangeService() {
		return couponCodeExchangeService;
	}

}
