package com.thebeastshop.member.util;

import com.thebeastshop.member.point.constant.MemberPointConstant;
import com.thebeastshop.member.point.cron.SaveMemberPointCron;

import java.math.BigDecimal;

/**
 * create by com.thebeastshop.member.util member :author lijing
 * User:lijing
 * DATE : 2016/12/5
 * TIME : 16:44
 * member.
 */
public class MemberPointUtil {
    private static final String TABLE_NAME = MemberPointConstant.Point_Table_Name.TABLE_NAME;
    private static final int MOD_FACTOR = 128;

    /**
     * 通过memberId
     * @param memberId
     * @return
     */
    public static  String getMemberPointTableName(Long memberId){
        String tableName = "";
        if(null == memberId || memberId <= 0L){
            return tableName;
        }
        Long factor = (memberId % MOD_FACTOR) + 1;
        tableName = TABLE_NAME + factor;
        return tableName;
    }

    /**
     *返回id 懒的去查询表了
     * @param memberId
     * @return
     */
    public static int getMemberPointTableId(Long memberId){
        if(null == memberId || memberId == 0L){
          throw new RuntimeException("参数错误");
        }
       int  tableId = (int)((memberId % MOD_FACTOR) + 1);
        return tableId;
    }

    /**
     * 转换参数vo
     * @param memberId
     * @param memberCode
     * @param referenceCode
     * @param point
     * @param type
     * @return
     */
    public static SaveMemberPointCron convertSaveMemberPointCronBean(Long memberId,String memberCode, String referenceCode, BigDecimal point, Integer type){
        SaveMemberPointCron saveMemberPointCron = new SaveMemberPointCron();
        saveMemberPointCron.setMemberCode(memberCode);
        saveMemberPointCron.setReferenceCode(referenceCode);
        saveMemberPointCron.setMemberId(memberId);
        saveMemberPointCron.setPoint(point);
        saveMemberPointCron.setType(type);
        return  saveMemberPointCron;
    }

}
