package com.thebeastshop.member.point.cron;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 参数分页信息
 * create by com.thebeastshop.member.point.cron member :author lijing
 * User:lijing
 * DATE : 2016/12/16
 * TIME : 15:15
 * member.
 */
public class PageCond implements Serializable {

    private int currentPage = 1; // 从1页开始

    private int pageSize = 20;  // 每页数据显示数量

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getRecordStart() {
        return this.currentPage * this.pageSize;
    }

    public Integer getOffset() {
        if ( currentPage < 1  || pageSize < 1) {
            return 0;
        }
        return  (currentPage -1) * pageSize;
    }
    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("currentPage", currentPage)
                .append("pageSize", pageSize)
                .toString();
    }
}
