package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;

import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.es.PsCategoryCampaignVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * Created by gensheng.ye on 2017/11/22.
 */
@EsDaoConfig(id = "id", type = "pubcategorycampaign")
public class CategoryCampaignEsDao  extends AbstractEsDao<PsCategoryCampaignVO> {

    @Autowired
    public CategoryCampaignEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }



    public void batchSave(List<PsCategoryCampaignVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        for (PsCategoryCampaignVO vo : list) {
            Map<String, Object> sourceMap = vo.toMap();
            String id = MapUtils.getString(sourceMap, this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
            } else {
                UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
                bulkRequest.add(updateRequest);
            }
        }
        bulkRequest.execute().actionGet();
    }

    @Override
    public PsCategoryCampaignVO toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsCategoryCampaignVO psCategoryCampaignVO = new PsCategoryCampaignVO();
        psCategoryCampaignVO.setId(MapUtils.getLong(sourceMap, "id"));
        psCategoryCampaignVO.setPsCampaignVOs((List<PsCampaignVO>)sourceMap.get("psCampaignVOs"));
        psCategoryCampaignVO.setPsCampaignVOSize(MapUtils.getInteger(sourceMap,"psCampaignVOSize"));
        return super.toBean(sourceMap);
    }

    @Override
    public Map<String, Object> toMap(PsCategoryCampaignVO psCategoryCampaignVO) {
        return super.toMap(psCategoryCampaignVO);
    }
}
