/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.EsUtil;
import com.thebeastshop.es.dao.SpvEsDao;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.es.PsChnProdSaleSku;
import com.thebeastshop.scm.es.PsChnProdTimeCodeInfo;
import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.es.PsSkuAttributeVO;
import com.thebeastshop.scm.es.PsSpvVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="id", type="pubprod")
public class ProductEsDao
extends AbstractEsDao<PsProductVO> {
    @Resource
    private SpvEsDao spvEsDao;

    @Autowired
    public ProductEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            Map<String, Object> sourceMap = this.toMap(vo);
            ArrayList<Map<String, Object>> spvListMap = new ArrayList<Map<String, Object>>();
            if (vo.getSpvList() != null) {
                for (PsSpvVO spvVO : vo.getSpvList()) {
                    if (spvVO == null) continue;
                    spvListMap.add(this.spvEsDao.toMap(spvVO));
                }
            }
            sourceMap.put("spvList", spvListMap);
            String id = MapUtils.getString(sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchSave.List<PsProductVO>", null);
    }

    public void batchUpdateCalSaleProd(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            List PsChnProdTimeCodeInfo;
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("onShelfChnCodes", vo.getOnShelfChnCodes());
            sourceMap.put("onShelfChnCodesOnLine", vo.getOnShelfChnCodesOnLine());
            sourceMap.put("chnCanSaleSKu", this.toListMap(vo.getChnCanSaleSKu()));
            sourceMap.put("chnCanSeeSKu", this.toListMap(vo.getChnCanSeeSKu()));
            sourceMap.put("chnCanSaleSKuOnLine", this.toListMap(vo.getChnCanSaleSKuOnLine()));
            sourceMap.put("chnCanSeeSKuOnLine", this.toListMap(vo.getChnCanSeeSKuOnLine()));
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("listPriceList", vo.getListPriceList());
            sourceMap.put("originalPrice", vo.getOriginalPrice());
            if (vo.getStocks() != null) {
                sourceMap.put("stocks", vo.getStocks());
            }
            if (CollectionUtils.isNotEmpty((Collection)vo.getStocksOnLine())) {
                sourceMap.put("stocksOnLine", vo.getStocksOnLine());
            }
            if (vo.getActivityPage() != null) {
                sourceMap.put("activityPage", vo.getActivityPage());
            }
            if (vo.getPrimaryUpdateTime() != null) {
                sourceMap.put("primaryUpdateTime", vo.getPrimaryUpdateTime());
            }
            if (vo.getPrimaryUpdateLong() != null) {
                sourceMap.put("primaryUpdateLong", vo.getPrimaryUpdateLong());
            }
            if (CollectionUtils.isNotEmpty((Collection)(PsChnProdTimeCodeInfo = vo.getChannelProdInfo()))) {
                sourceMap.put("channelProdInfo", this.toListMap(PsChnProdTimeCodeInfo));
            }
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateCalSaleProd.List<PsProductVO>", null);
    }

    public void batchUpdateSku(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("skuCodes", vo.getSkuCodes());
            sourceMap.put("categoryId", vo.getCategoryId());
            sourceMap.put("categoryCode", vo.getCategoryCode());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateSku.List<PsProductVO>", null);
    }

    public void batchUpdateBrand(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Map> sourceMap = new HashMap<String, Map>();
            sourceMap.put("brand", vo.getBrand());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateBrand.List<PsProductVO>", null);
    }

    public void batchUpdateLabel(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List> sourceMap = new HashMap<String, List>();
            sourceMap.put("labels", vo.getLabels());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateLabel.List<PsProductVO>", null);
    }

    public void batchUpdateSpv(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> spvListMap = new ArrayList<Map<String, Object>>();
            for (PsSpvVO spvVO : vo.getSpvList()) {
                spvListMap.add(this.spvEsDao.toMap(spvVO));
            }
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("listPriceList", vo.getListPriceList());
            sourceMap.put("originalPrice", vo.getOriginalPrice());
            sourceMap.put("spvList", spvListMap);
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateSpv.List<PsProductVO>", null);
    }

    public void batchUpdateStocks(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("stocks", vo.getStocks());
            if (CollectionUtils.isNotEmpty((Collection)vo.getStocksOnLine())) {
                sourceMap.put("stocksOnLine", vo.getStocksOnLine());
            }
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("originalPrice", vo.getOriginalPrice());
            sourceMap.put("listPriceList", vo.getListPriceList());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateStocks.List<PsProductVO>", null);
    }

    public void batchUpdateCampaign(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                continue;
            }
            HashMap<String, List<Map>> sourceMap = new HashMap<String, List<Map>>();
            if (vo.getCampaignList() == null) continue;
            List<Map> campaignList = this.toListMap(vo.getCampaignList());
            sourceMap.put("campaignList", campaignList);
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "ProductEsDao.batchUpdateCampaign.List<PsProductVO>", null);
    }

    @Override
    public PsProductVO toBean(Map<String, Object> sourceMap) {
        List listMap;
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsProductVO productEsVO = new PsProductVO();
        productEsVO.setId(MapUtils.getString(sourceMap, (Object)"id"));
        productEsVO.setCode(MapUtils.getString(sourceMap, (Object)"code"));
        String listPrice = MapUtils.getString(sourceMap, (Object)"listPrice");
        if (StringUtils.isNotBlank((CharSequence)listPrice)) {
            productEsVO.setListPrice(new BigDecimal(listPrice));
        }
        productEsVO.setAllowVipDiscount(MapUtils.getInteger(sourceMap, (Object)"allowVipDiscount"));
        productEsVO.setAllowBdDiscount(MapUtils.getInteger(sourceMap, (Object)"allowBdDiscount"));
        productEsVO.setAllowCampaign(MapUtils.getInteger(sourceMap, (Object)"allowCampaign"));
        productEsVO.setAllowCoupon(MapUtils.getInteger(sourceMap, (Object)"allowCoupon"));
        productEsVO.setAllowNoteCard(MapUtils.getInteger(sourceMap, (Object)"allowNoteCard"));
        productEsVO.setPicList(MapUtils.getString(sourceMap, (Object)"picList"));
        productEsVO.setPicDetailMul(MapUtils.getString(sourceMap, (Object)"picDetailMul"));
        productEsVO.setExpressType(MapUtils.getInteger(sourceMap, (Object)"expressType", (Integer)3));
        productEsVO.setName(MapUtils.getString(sourceMap, (Object)"name"));
        productEsVO.setNameCn(MapUtils.getString(sourceMap, (Object)"nameCn"));
        productEsVO.setSkuCategoryDesc(MapUtils.getString(sourceMap, (Object)"skuCategoryDesc"));
        productEsVO.setCategoryId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"categoryId")));
        productEsVO.setCategoryCode(MapUtils.getString(sourceMap, (Object)"categoryCode", (String)""));
        productEsVO.setHasDeliveryDate(MapUtils.getInteger(sourceMap, (Object)"hasDeliveryDate"));
        productEsVO.setDescription(MapUtils.getString(sourceMap, (Object)"description"));
        productEsVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, (Object)"crossBorderFlag"));
        productEsVO.setIsJit(MapUtils.getInteger(sourceMap, (Object)"isJit"));
        productEsVO.setCanCustomize(MapUtils.getInteger(sourceMap, (Object)"canCustomize"));
        productEsVO.setWhetherLogistics(MapUtils.getInteger(sourceMap, (Object)"whetherLogistics"));
        productEsVO.setUpdateTime(MapUtils.getString(sourceMap, (Object)"updateTime"));
        productEsVO.setUpdateLong(MapUtils.getString(sourceMap, (Object)"updateLong"));
        productEsVO.setSkuCodes((List)sourceMap.get("skuCodes"));
        productEsVO.setSmallIconList((List)sourceMap.get("smallIconList"));
        productEsVO.setLargeIconList((List)sourceMap.get("largeIconList"));
        productEsVO.setDetailNumList((List)sourceMap.get("detailNumList"));
        productEsVO.setOnShelfChnCodes((List)sourceMap.get("onShelfChnCodes"));
        productEsVO.setOnShelfChnCodesOnLine((List)sourceMap.get("onShelfChnCodesOnLine"));
        productEsVO.setFrontCategories((List)sourceMap.get("frontCategories"));
        productEsVO.setSecondFrontCategories((List)sourceMap.get("secondFrontCategories"));
        productEsVO.setStocks((List)sourceMap.get("stocks"));
        productEsVO.setStocksOnLine((List)sourceMap.get("stocksOnLine"));
        productEsVO.setChnCanSaleSKu(this.toListBean(sourceMap, "chnCanSaleSKu", PsChnProdSaleSku.class));
        productEsVO.setChnCanSeeSKu(this.toListBean(sourceMap, "chnCanSeeSKu", PsChnProdSaleSku.class));
        productEsVO.setChnCanSeeSKuOnLine(this.toListBean(sourceMap, "chnCanSeeSKuOnLine", PsChnProdSaleSku.class));
        productEsVO.setChnCanSaleSKuOnLine(this.toListBean(sourceMap, "chnCanSaleSKuOnLine", PsChnProdSaleSku.class));
        productEsVO.setLabels((List)sourceMap.get("labels"));
        productEsVO.setAttributeList(this.toListBean(sourceMap, "attributeList", PsAttributeVO.class));
        productEsVO.setSpvList(this.toListBean(sourceMap, "spvList", PsSpvVO.class));
        productEsVO.setSkuAttributeList(this.toListBean(sourceMap, "skuAttributeList", PsSkuAttributeVO.class));
        productEsVO.setSkuNameCnList((List)sourceMap.get("skuNameCnList"));
        productEsVO.setActivityPage((List)sourceMap.get("activityPage"));
        productEsVO.setPsCommissionList((List)sourceMap.get("psCommissionList"));
        String returnFundProportion = MapUtils.getString(sourceMap, (Object)"returnFundProportion");
        String useFundProportion = MapUtils.getString(sourceMap, (Object)"useFundProportion");
        if (StringUtils.isNotBlank((CharSequence)returnFundProportion)) {
            productEsVO.setReturnFundProportion(new BigDecimal(returnFundProportion));
        }
        if (StringUtils.isNotBlank((CharSequence)useFundProportion)) {
            productEsVO.setUseFundProportion(new BigDecimal(useFundProportion));
        }
        productEsVO.setCommissionFlag(MapUtils.getInteger(sourceMap, (Object)"commissionFlag"));
        productEsVO.setListDisplayVideo(MapUtils.getString(sourceMap, (Object)"listDisplayVideo"));
        Object channelProdInfoObj = sourceMap.get("channelProdInfo");
        if (channelProdInfoObj != null && CollectionUtils.isNotEmpty((Collection)(listMap = (List)channelProdInfoObj))) {
            ArrayList<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<PsChnProdTimeCodeInfo>();
            for (Map map : listMap) {
                String channelCode = MapUtils.getString((Map)map, (Object)"channelCode");
                if (StringUtils.isBlank((CharSequence)channelCode)) continue;
                String creatTimeString = MapUtils.getString((Map)map, (Object)"createTime");
                Date creatTime = null;
                if (StringUtils.isNotBlank((CharSequence)creatTimeString)) {
                    creatTime = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parseDateTime(creatTimeString).plusHours(8).toDate();
                }
                channelProdInfo.add(new PsChnProdTimeCodeInfo(channelCode, creatTime));
            }
            productEsVO.setChannelProdInfo(channelProdInfo);
        }
        return productEsVO;
    }

    @Override
    public Map<String, Object> toMap(PsProductVO vo) {
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("id", vo.getId());
        sourceMap.put("prodId", vo.getId());
        sourceMap.put("code", vo.getCode());
        sourceMap.put("combined", vo.getCombined() == null ? 0 : vo.getCombined());
        BigDecimal listPrice = vo.getListPrice();
        BigDecimal originalPrice = vo.getOriginalPrice();
        if (listPrice != null) {
            sourceMap.put("listPrice", listPrice.doubleValue());
        }
        if (originalPrice != null) {
            sourceMap.put("originalPrice", originalPrice.doubleValue());
        }
        if (vo.getListPriceSkuCode() != null) {
            sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
        }
        if (vo.getListPriceSpvId() != null) {
            sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
        }
        sourceMap.put("listPriceList", vo.getListPriceList());
        sourceMap.put("allowVipDiscount", vo.getAllowVipDiscount());
        sourceMap.put("allowBdDiscount", vo.getAllowBdDiscount());
        sourceMap.put("allowCampaign", vo.getAllowCampaign());
        sourceMap.put("allowCoupon", vo.getAllowCoupon());
        sourceMap.put("allowNoteCard", vo.getAllowNoteCard());
        sourceMap.put("picList", vo.getPicList());
        sourceMap.put("picDetailMul", vo.getPicDetailMul());
        sourceMap.put("expressType", vo.getExpressType());
        sourceMap.put("name", vo.getName());
        sourceMap.put("nameCn", vo.getNameCn());
        if (vo.getSkuCategoryDesc() != null) {
            sourceMap.put("skuCategoryDesc", vo.getSkuCategoryDesc());
        }
        sourceMap.put("categoryId", vo.getCategoryId());
        sourceMap.put("categoryCode", vo.getCategoryCode());
        sourceMap.put("description", vo.getDescription());
        if (vo.getPrimaryUpdateTime() != null) {
            sourceMap.put("primaryUpdateTime", vo.getPrimaryUpdateTime());
        }
        if (vo.getPrimaryUpdateLong() != null) {
            sourceMap.put("primaryUpdateLong", vo.getPrimaryUpdateLong());
        }
        sourceMap.put("crossBorderFlag", vo.getCrossBorderFlag());
        sourceMap.put("isJit", vo.getIsJit());
        sourceMap.put("canCustomize", vo.getCanCustomize());
        sourceMap.put("whetherLogistics", vo.getWhetherLogistics());
        sourceMap.put("skuCodes", vo.getSkuCodes());
        sourceMap.put("smallIconList", vo.getSmallIconList());
        sourceMap.put("largeIconList", vo.getLargeIconList());
        sourceMap.put("detailNumList", vo.getDetailNumList());
        sourceMap.put("onShelfChnCodes", vo.getOnShelfChnCodes());
        sourceMap.put("onShelfChnCodesOnLine", vo.getOnShelfChnCodesOnLine());
        sourceMap.put("frontCategories", vo.getFrontCategories());
        sourceMap.put("secondFrontCategories", vo.getSecondFrontCategories());
        sourceMap.put("stocks", vo.getStocks());
        sourceMap.put("stocksOnLine", vo.getStocksOnLine());
        sourceMap.put("chnCanSaleSKu", this.toListMap(vo.getChnCanSaleSKu()));
        sourceMap.put("chnCanSeeSKu", this.toListMap(vo.getChnCanSeeSKu()));
        sourceMap.put("chnCanSaleSKuOnLine", this.toListMap(vo.getChnCanSaleSKuOnLine()));
        sourceMap.put("chnCanSeeSKuOnLine", this.toListMap(vo.getChnCanSeeSKuOnLine()));
        sourceMap.put("channelProdInfo", this.toListMap(vo.getChannelProdInfo()));
        sourceMap.put("labels", vo.getLabels());
        sourceMap.put("campaignList", this.toListMap(vo.getCampaignList()));
        sourceMap.put("spvList", this.toListMap(vo.getSpvList()));
        sourceMap.put("isDiscount", vo.getIsDiscount());
        sourceMap.put("video", vo.getVideo());
        sourceMap.put("videoCover", vo.getVideoCover());
        sourceMap.put("giftRecommendImg", vo.getGiftRecommendImg());
        sourceMap.put("giftRecommendReason", vo.getGiftRecommendReason());
        sourceMap.put("displayInProdDetail", vo.getDisplayInProdDetail());
        sourceMap.put("displayInCombinedArea", vo.getDisplayInCombinedArea());
        sourceMap.put("skuAttributeList", this.toListMap(vo.getSkuAttributeList()));
        sourceMap.put("backCategoryIds", vo.getBackCategoryIds());
        sourceMap.put("skuNameCnList", vo.getSkuNameCnList());
        sourceMap.put("integratedPoint", vo.getIntegratedPoint());
        sourceMap.put("barcodes", vo.getBarcodes());
        sourceMap.put("detailBigimgSeq", vo.getDetailBigimgSeq());
        sourceMap.put("detailBigimgUrl", vo.getDetailBigimgUrl());
        sourceMap.put("bu", vo.getBu());
        sourceMap.put("newBu", vo.getNewBu());
        sourceMap.put("newBuId", vo.getNewBuId());
        sourceMap.put("brand", vo.getBrand());
        sourceMap.put("activityPage", vo.getActivityPage());
        if (vo.getVirtualType() != null && vo.getVirtualType() == 2) {
            sourceMap.put("virtualType", 2);
            sourceMap.put("beastCourserReserveStartTime", vo.getBeastCourserReserveStartTime());
            sourceMap.put("beastCourseStatus", vo.getBeastCourseStatus());
            sourceMap.put("beastCourserSessionStartTime", vo.getBeastCourserSessionStartTime());
        } else {
            sourceMap.put("virtualType", 1);
        }
        sourceMap.put("sellOnLine", vo.getSellOnLine());
        sourceMap.put("isWechatGift", vo.getIsWechatGift());
        sourceMap.put("psCommissionList", this.toListMap(vo.getPsCommissionList()));
        sourceMap.put("commissionFlag", vo.getCommissionFlag());
        sourceMap.put("listDisplayVideo", vo.getListDisplayVideo());
        sourceMap.put("returnFundProportion", vo.getReturnFundProportion());
        sourceMap.put("useFundProportion", vo.getUseFundProportion());
        sourceMap.put("customPrintTemplate", vo.getCustomPrintTemplate());
        sourceMap.put("isVipDiscountWhiteProd", vo.getIsVipDiscountWhiteProd());
        sourceMap.put("isMatchProd", vo.getIsMatchProd());
        sourceMap.put("hasDeliveryDate", vo.getHasDeliveryDate());
        sourceMap.put("combination", vo.getCombination());
        return sourceMap;
    }

    public static void main(String[] args) {
        String saleStartDateString = "2015-01-01";
        Date saleStartDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseDateTime(saleStartDateString).toDate();
        System.out.println(saleStartDate);
    }
}

